/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http.linked;

import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class HeaderInterceptor {
    private Logger logger = Logger.getLogger(HeaderInterceptor.class.getName());
    public static String tokenKey = "x-mn-token";
    public static String siteKey = "x-mn-site";
    public static String clientIdKey = "x-client-id";
    public static String changeTokenKey = "x-change-token";
    public static String clearTokenKey = "x-clear-token";

    public boolean beforeRequest(boolean requireAuth, Map<String, String> localStorage, Map<String, String> headers, Supplier<String> tokenSupplier) {
        String token = localStorage.get(tokenKey);
        if (requireAuth && token != null) {
            token = tokenSupplier.get();
            localStorage.putIfAbsent(tokenKey, token);
        }
        headers.putIfAbsent(tokenKey, token);
        String site = localStorage.get(siteKey);
        headers.putIfAbsent(siteKey, site);
        String clientId = localStorage.get(clientIdKey);
        clientId = this.sureRightClientId(clientId);
        headers.put(clientIdKey, clientId);
        return true;
    }

    public boolean afterRequest(Map<String, String> localStorage, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        if (responseHeaders.get(clearTokenKey) != null) {
            localStorage.remove(tokenKey);
        }
        if (responseHeaders.get(changeTokenKey) != null) {
            localStorage.put(tokenKey, responseHeaders.get(changeTokenKey));
        }
        return true;
    }

    public String sureRightClientId(String clientId) {
        if (clientId != null && Pattern.matches("//d{27}", clientId)) {
            return clientId;
        }
        return DateFormatUtils.format((Date)new Date(), (String)"yyyyMMDDHHmmssSSS") + RandomStringUtils.randomNumeric((int)10);
    }
}

