/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http.linked;

import com.mini.framework.util.http.linked.HttpResponse;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpResponseHandler<T> {
    private static Logger logger = Logger.getLogger(HttpResponseHandler.class.getName());
    private Consumer<HttpResponse> responseFilter;
    private Function<HttpResponse, Boolean> responseIntercept;
    private Function<HttpResponse, T> responseResolver;
    private String charset = "utf-8";

    public HttpResponseHandler<T> bindFilter(Consumer<HttpResponse> responseFilter) {
        this.responseFilter = responseFilter;
        return this;
    }

    public HttpResponseHandler<T> bindIntercept(Function<HttpResponse, Boolean> responseIntercept) {
        this.responseIntercept = responseIntercept;
        return this;
    }

    public HttpResponseHandler<T> bindResolver(Function<HttpResponse, T> responseResolver) {
        this.responseResolver = responseResolver;
        return this;
    }

    private HttpResponseHandler() {
        this.initDefault();
    }

    private void initDefault() {
        this.bindIntercept(resp -> {
            int status = resp.getStatus();
            switch (status / 100) {
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
            }
            return false;
        });
    }

    public static HttpResponseHandler<String> createString() {
        return HttpResponseHandler.create(String.class).bindResolver(resp -> resp.getBody() + "");
    }

    public static <T> HttpResponseHandler<T> create(Class<T> clazz) {
        return new HttpResponseHandler<T>();
    }

    public void validate() {
    }

    public T hande(HttpResponse response) {
        this.validate();
        try {
            this.responseFilter.accept(response);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "\u8fc7\u7a0b\u5668\u51fa\u6765\u5f02\u5e38\u5ffd\u7565", e);
        }
        Boolean right = this.responseIntercept.apply(response);
        if (right.booleanValue()) {
            return this.responseResolver.apply(response);
        }
        return null;
    }
}

