/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean;

import com.mini.framework.core.exception.standard.UnsupportedException;
import java.util.Optional;

public enum MapDirection {
    nw(0, 0),
    north(0, 1),
    ne(0, 2),
    west(1, 0),
    center(1, 1),
    east(1, 2),
    sw(2, 0),
    south(2, 1),
    se(2, 2);

    private int nsIndex;
    private int weIndex;

    public int getNsIndex() {
        return this.nsIndex;
    }

    public void setNsIndex(int nsIndex) {
        this.nsIndex = nsIndex;
    }

    public int getWeIndex() {
        return this.weIndex;
    }

    public void setWeIndex(int weIndex) {
        this.weIndex = weIndex;
    }

    private MapDirection(int nsIndex, int weIndex) {
        this.nsIndex = nsIndex;
        this.weIndex = weIndex;
    }

    public Optional<Integer> countNsFromPoint(int size, int offset, int limit) {
        return this.countFromPoint(true, size, offset, limit);
    }

    public Optional<Integer> countWeFromPoint(int size, int offset, int limit) {
        return this.countFromPoint(false, size, offset, limit);
    }

    private Optional<Integer> countFromPoint(boolean ns, int size, int offset, int limit) {
        int judge = ns ? this.nsIndex : this.weIndex;
        switch (judge) {
            case 0: {
                return Optional.of(offset);
            }
            case 1: {
                return Optional.empty();
            }
            case 2: {
                return Optional.of(size - (offset + limit));
            }
        }
        throw new UnsupportedException("countFromPoint\u4e2dindex\u51fa\u73b0\u4e86012\u4ee5\u5916\u6570\u5b57:[%s]", new Object[]{judge});
    }
}

