/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean.work.mark;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.mark.MarkOssImageWork;
import com.mini.framework.util.oss.bean.work.type.OriginType;
import com.mini.framework.util.oss.bean.work.type.TextWordsType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

@Desc(value="\u56fe\u7247\u4e0a\u7684\u6587\u672c\u6c34\u5370")
public class TextMarkOssImageWork
extends MarkOssImageWork {
    private static final int textMaxLength = 20;
    private static final String textSpace = "\u3000";
    private static final String textEndWith = "\u2026";
    @Desc(value="6\u4f4d\u989c\u8272\u9ed8\u8ba4\u662f000000")
    private @Desc(value="6\u4f4d\u989c\u8272\u9ed8\u8ba4\u662f000000") String color;
    @Desc(value="\u6587\u5b57\u7684\u6587\u672c")
    private @Desc(value="\u6587\u5b57\u7684\u6587\u672c") String text;
    @Desc(value="\u6c34\u5370\u6587\u672c\u7684\u5b57\u4f53")
    private @Desc(value="\u6c34\u5370\u6587\u672c\u7684\u5b57\u4f53") TextWordsType type;
    @Desc(value="\u6c34\u5370\u6587\u672c\u7684\u5b50\u53f7(0,1000]\u9ed8\u8ba440")
    private @Desc(value="\u6c34\u5370\u6587\u672c\u7684\u5b50\u53f7(0,1000]\u9ed8\u8ba440") Integer size;
    @Desc(value="\u6587\u5b57\u6c34\u5370\u7684\u9634\u5f71\u900f\u660e\u5ea6[0,100]")
    private @Desc(value="\u6587\u5b57\u6c34\u5370\u7684\u9634\u5f71\u900f\u660e\u5ea6[0,100]") Integer shadow;
    @Desc(value="\u6587\u5b57\u987a\u65f6\u9488\u65cb\u8f6c\u89d2\u5ea6[0,360]")
    private @Desc(value="\u6587\u5b57\u987a\u65f6\u9488\u65cb\u8f6c\u89d2\u5ea6[0,360]") Integer rotate;
    @Desc(value="\u8fdb\u884c\u6c34\u5370\u94fa\u6ee1\u7684\u6548\u679c [0,1] 1\u8868\u793a\u94fa\u6ee1\uff0c0\u8868\u793a\u6548\u679c\u65e0\u6548")
    private @Desc(value="\u8fdb\u884c\u6c34\u5370\u94fa\u6ee1\u7684\u6548\u679c [0,1] 1\u8868\u793a\u94fa\u6ee1\uff0c0\u8868\u793a\u6548\u679c\u65e0\u6548") Integer fill;
    @Desc(value="\u6700\u5927\u9650\u5236\u591a\u5c11\u4e2a\u5b57\uff0c\u8d85\u8fc7\u4e86\u4f7f\u7528\u2026\u4ee3\u66ff")
    private @Desc(value="\u6700\u5927\u9650\u5236\u591a\u5c11\u4e2a\u5b57\uff0c\u8d85\u8fc7\u4e86\u4f7f\u7528\u2026\u4ee3\u66ff") Integer lengthLimit;

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextWordsType getType() {
        return this.type;
    }

    public void setType(TextWordsType type) {
        this.type = type;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getShadow() {
        return this.shadow;
    }

    public void setShadow(Integer shadow) {
        this.shadow = shadow;
    }

    public Integer getRotate() {
        return this.rotate;
    }

    public void setRotate(Integer rotate) {
        this.rotate = rotate;
    }

    public Integer getFill() {
        return this.fill;
    }

    public void setFill(Integer fill) {
        this.fill = fill;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public void setLengthLimit(Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    public String showUsefulText() {
        String text = Optional.ofNullable(this.text).orElse(textSpace);
        int length = Stream.of(this.lengthLimit, 20).filter(Objects::nonNull).mapToInt(Integer::valueOf).filter(v -> v > 0).min().getAsInt();
        text = text.length() > length ? text.substring(0, length - 1) + textEndWith : text;
        return text;
    }

    @Override
    public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
        String text = this.showUsefulText();
        return super.mapperProcessParams(sureSameBucket).paramBase64("text", text).paramIfVal("color", this.color).paramIfVal("size", this.size).paramIfVal("shadow", this.shadow).paramIfVal("rotate", this.rotate).paramIfVal("fill", this.fill).paramIfVal("type", this.type.base64());
    }

    public TextMarkOssImageWork() {
    }

    public TextMarkOssImageWork(String color, String text, TextWordsType type, Integer size, Integer shadow, Integer rotate, Integer fill, Integer lengthLimit) {
        this.color = color;
        this.text = text;
        this.type = type;
        this.size = size;
        this.shadow = shadow;
        this.rotate = rotate;
        this.fill = fill;
        this.lengthLimit = lengthLimit;
    }

    public static List<TextMarkOssImageWork> createExamples() {
        ArrayList<TextMarkOssImageWork> examples = new ArrayList<TextMarkOssImageWork>();
        TextMarkOssImageWork example = new TextMarkOssImageWork("000000", "${\u8fd9\u91cc\u5199\u6587\u672c\u5360\u4f4d\u7b26}", TextWordsType.droidsansfallback, null, 10, 12, 0, 8);
        example.fillParams(80, OriginType.nw, 100, 100, 100).fillParams(50.0, "\u589e\u52a0\u4e00\u4e2a\u6587\u672c\u6c34\u5370\uff0c\u9700\u8981\u81ea\u884c\u4fee\u6539\u5360\u4f4d\u7b26");
        examples.add(example);
        return examples;
    }
}

