/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.photo;

import com.mini.framework.util.bean.VarUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.type.EnumTypeShower;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Desc(value="\u9ad8\u7626/\u6b63\u65b9/\u77ee\u80d6\u7c7b\u578b\uff0c\u5bf9\u4e8e\u4e0d\u540c\u7684\u56fe\u7247\u7c97\u7565\u5206\u7c7b\u6210\u4e09\u79cd")
public enum PhotoBodilyFormType implements EnumTypeShower<PhotoBodilyFormType>
{
    height(1.33, 1.6179999999999999, 2.0, "\u9ad8\u7626\u578b", "\u9ad8\u5ea6\u6bd4\u5bbd\u5ea6\u5927\u7684"),
    square(0.8, 1.0, 1.25, "\u6b63\u65b9\u578b", "\u9ad8\u5ea6\u6bd4\u5bbd\u5ea6\u5dee\u4e0d\u591a\u5927\u7684"),
    width(0.57, 0.618, 0.67, "\u77ee\u80d6\u578b", "\u9ad8\u5ea6\u6bd4\u5bbd\u5ea6\u5c0f\u7684"),
    flat(0.4, 0.5, 0.5625, "\u6241\u5f62\u7684", "\u9ad8\u5ea6\u6bd4\u5bbd\u5ea6\u5c0f\u5f88\u591a\u7684");

    private Double minRatio;
    private Double perfectRatio;
    private Double maxRatio;
    private String title;
    private String desc;

    public String title() {
        return this.title;
    }

    public String desc() {
        return this.desc;
    }

    private PhotoBodilyFormType(Double minRatio, Double perfectRatio, Double maxRatio, String title, String desc) {
        this.minRatio = minRatio;
        this.perfectRatio = perfectRatio;
        this.maxRatio = maxRatio;
        this.title = title;
        this.desc = desc;
    }

    public boolean matchRatioScope(double ratio) {
        return this.minRatio <= ratio && this.maxRatio >= ratio;
    }

    public static Optional<PhotoBodilyFormType> findByRatioScope(int width, int height) {
        return PhotoBodilyFormType.findByRatioScope(PhotoBodilyFormType.countRatio(height, width));
    }

    public static Optional<PhotoBodilyFormType> findByRatioScope(double ratio) {
        return Stream.of(PhotoBodilyFormType.values()).filter(type -> type.matchRatioScope(ratio)).findFirst();
    }

    private static double countRatio(int height, int width) {
        return 1.0 * (double)height / (double)width;
    }

    public static Map.Entry<Integer, Integer> cutSizeByRatio(double suitableRatio, int width, int height) {
        double ratio = PhotoBodilyFormType.countRatio(height, width);
        if (suitableRatio > ratio) {
            width = (int)((double)height / suitableRatio);
        } else {
            height = (int)(suitableRatio * (double)width);
        }
        return VarUtil.createEntry(width, height);
    }

    public Map.Entry<Integer, Integer> cutPerfectSize(int width, int height) {
        return PhotoBodilyFormType.cutSizeByRatio(this.perfectRatio, width, height);
    }

    public Map.Entry<Integer, Integer> cutSuitableSize(int width, int height) {
        double ratio = PhotoBodilyFormType.countRatio(width, height);
        if (ratio > this.maxRatio) {
            return PhotoBodilyFormType.cutSizeByRatio(this.maxRatio, width, height);
        }
        if (ratio < this.minRatio) {
            return PhotoBodilyFormType.cutSizeByRatio(this.minRatio, width, height);
        }
        return VarUtil.createEntry(width, height);
    }

    @Override
    public void fillFieldToMap(Map<String, Object> map) {
        map.put("title", this.title);
        map.put("maxRatio", this.maxRatio);
        map.put("minRatio", this.minRatio);
        map.put("perfectRatio", this.perfectRatio);
        map.put("desc", this.desc);
    }
}

