/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.require.bean;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.VarUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.require.bean.FieldFinder;
import com.mini.framework.util.require.bean.FieldFinderTraversal;
import com.mini.framework.util.require.bean.ParamFieldPair;
import com.mini.framework.util.require.bean.Queryer;
import com.mini.framework.util.require.bean.RequireParams;
import com.mini.framework.util.require.bean.SwitchQueryer;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.util.string.bean.SplitItemPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageBuilder {
    private static Logger logger = LogManager.getLogger(MessageBuilder.class);
    private List<Append> appends = new ArrayList<Append>();
    private static SwitchQueryer switchQueryer;
    private static ConcurrentHashMap<String, ParamFieldPair> allFieldPairs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(SwitchQueryer switchQueryer, FieldFinderTraversal fieldFinderTraversal) {
        AssertUtil.assertMethodRequire(switchQueryer, "switchQueryer");
        AssertUtil.assertMethodRequire(fieldFinderTraversal, "fieldFinderTraversal");
        if (MessageBuilder.isInit()) return;
        Class<MessageBuilder> clazz = MessageBuilder.class;
        synchronized (MessageBuilder.class) {
            if (!MessageBuilder.isInit()) {
                MessageBuilder.storeToStatic(switchQueryer, fieldFinderTraversal);
            } else {
                logger.error("MessageBuilder\u53ea\u9700\u8981\u88ab\u521d\u59cb\u5316\u4e00\u6b21");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isInit() {
        return switchQueryer != null;
    }

    private MessageBuilder() {
    }

    public static MessageBuilder create() {
        if (MessageBuilder.isInit()) {
            return new MessageBuilder();
        }
        throw new UnsupportedException("MessageBuilder\u8fd8\u6ca1\u6709\u88ab\u6210\u529f\u521d\u59cb\u5316", new Object[0]);
    }

    private static void storeToStatic(SwitchQueryer switchQueryer, FieldFinderTraversal fieldFinderTraversal) {
        MessageBuilder.switchQueryer = switchQueryer;
        allFieldPairs = new ConcurrentHashMap();
        ArrayList<ParamFieldPair> fieldPairs = new ArrayList<ParamFieldPair>(fieldFinderTraversal.traversal());
        fieldPairs.forEach(fieldPair -> {
            String expression = fieldPair.getExpression();
            AssertUtil.assertSupport(expression != null, "fieldFinderTraversal\u51fa\u73b0\u4e86expression\u4e3a\u7a7a\u7684\u6570\u636e", new Object[0]);
            AssertUtil.assertSupport(allFieldPairs.get(expression) == null, "fieldFinderTraversal\u51fa\u73b0\u4e86\u591a\u4e2aexpression:[%s]", expression);
            allFieldPairs.put(expression, (ParamFieldPair)fieldPair);
        });
    }

    public String build() {
        List appendStrings = this.appends.stream().map(append -> {
            Object[] args = ((Append)append).filedHolds.stream().map(filedHold -> {
                Queryer queryer = this.getQuery(switchQueryer, (ParamFieldPair)filedHold);
                return filedHold.execute(queryer);
            }).toArray();
            return String.format(((Append)append).string, args);
        }).collect(Collectors.toList());
        return String.join((CharSequence)"", appendStrings);
    }

    public MessageBuilder append(String string, ParamFieldPair ... delays) {
        Stream.of(delays).forEach(delay -> {
            AssertUtil.assertSupport(delay != null, "\u4e0d\u5141\u8bb8\u5199\u7a7a\u53c2\u6570", new Object[0]);
            this.getQuery(switchQueryer, (ParamFieldPair)delay);
        });
        this.appends.add(new Append(string, Arrays.asList(delays)));
        return this;
    }

    public MessageBuilder appendString(String template, Map<String, Object> params) {
        return this.appendString(template, RequireParams.create(params));
    }

    public MessageBuilder appendString(String template, RequireParams params) {
        logger.debug((Object)Event5WBuilder.event(1, "appendString").what("\u5c1d\u8bd5\u521b\u5efa\u6d88\u606f", new Object[0]).how("\u4f7f\u7528\u53c2\u6570 template:%s,params:%s", template, params));
        String funexp = RegexUtil.regexCharsAsNormal("${[1-9a-zA-Z.]*([1-9a-zA-Z.]*)}", "${}()");
        SplitItemPoint sip = RegexUtil.getSplitItemPoint(funexp, template);
        List<ParamFieldPair> delays = sip.getPoints().stream().map(point -> {
            String[] matchs = RegexUtil.getMatch("\\$\\{(.*)\\((.*)\\)\\}", point, 1, 2);
            String method = matchs[0];
            String paramStr = matchs[1];
            Object param = VarUtil.firstNotNull(params.get(paramStr), paramStr);
            FieldFinder fieldFinder = this.getFieldFinder(method);
            ParamFieldPair pair = new ParamFieldPair(method, () -> param, fieldFinder);
            return pair;
        }).collect(Collectors.toList());
        sip.setAllPoint("%s");
        String temp = sip.assem();
        for (Map.Entry<String, Object> entry : params.getValues().entrySet()) {
            if (!(entry.getValue() instanceof ParamFieldPair)) continue;
            String paramKey = entry.getKey();
            String explan = String.format("${%s}", paramKey);
            while (temp.contains(explan)) {
                String beforeStr = StringUtils.substringBefore((String)temp, (String)paramKey);
                int scount = StringUtils.countMatches((CharSequence)beforeStr, (CharSequence)"%s");
                delays.add(scount, (ParamFieldPair)entry.getValue());
                temp = StringUtils.replaceOnce((String)temp, (String)explan, (String)"%s");
            }
        }
        temp = RegexUtil.applyPlaceholder(temp, params.getValues());
        return this.append(temp, delays.toArray(new ParamFieldPair[0]));
    }

    private Queryer getQuery(SwitchQueryer switchQueryer, ParamFieldPair delay) {
        FieldFinder fieldFinder = delay.getFieldFinder();
        AssertUtil.assertSupport(switchQueryer != null, "\u6ca1\u6709%s\u5bf9\u5e94\u7684\u67e5\u8be2\u5668", fieldFinder);
        Queryer queryer = (Queryer)switchQueryer.apply(fieldFinder);
        AssertUtil.assertSupport(queryer != null, "\u6ca1\u6709%s\u5bf9\u5e94\u7684\u67e5\u8be2\u5668", fieldFinder);
        return queryer;
    }

    private FieldFinder getFieldFinder(String expression) {
        AssertUtil.assertMethodRequire(expression, "expression");
        AssertUtil.assertSupport(allFieldPairs != null, "\u5728\u4f7f\u7528\u5b57\u7b26\u4e32\u6a21\u677f\u529f\u80fd\u5728create\u7684\u65f6\u5019\u5fc5\u987b\u6dfb\u52a0\u6a21\u677f\u6620\u5c04fieldFinderTraversal", new Object[0]);
        ParamFieldPair pair = allFieldPairs.get(expression);
        AssertUtil.assertSupport(pair != null, "\u627e\u4e0d\u5230:[%s]\u5bf9\u5e94\u7684\u5ef6\u8fdf\u65b9\u6cd5", expression);
        return pair.getFieldFinder();
    }

    public static class Append {
        private String string;
        private List<ParamFieldPair> filedHolds;

        public Append(String string, List<ParamFieldPair> filedHolds) {
            this.string = string;
            this.filedHolds = filedHolds;
        }
    }
}

