/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.store;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.store.bean.Copyable;
import com.mini.framework.util.store.bean.StringKeyable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MemoryTableStorage<E extends StringKeyable<E>> {
    private List<E> storage = new ArrayList();

    public E coverSave(E element) {
        AssertUtil.assertNotFatalProgramConfig(element.showKey() != null, Status.Server.programConfigJava, "\u5143\u7d20\u7684key\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.removeByKey(element);
        this.storage.add(element.copy());
        return (E)((StringKeyable)this.queryOnlyOneByKey(element).orElseThrow(() -> new ServerException("\u5b58\u50a8\u5931\u8d25\u4e86 \u5143\u7d20:%s", new Object[]{element})));
    }

    public <F> boolean matchFilter(E element, F filter, Function<E, F> filterGetter) {
        return filter.equals(filterGetter.apply(element));
    }

    public <F> List<E> queryByFilter(F filter, Function<E, F> filterGetter) {
        return this.storage.stream().filter(element -> this.matchFilter(element, filter, filterGetter)).map(Copyable::copy).collect(Collectors.toList());
    }

    public <K> Optional<E> queryOnlyOneByKey(E element) {
        AssertUtil.assertNotFatalProgramConfig(element.showKey() != null, Status.Server.programConfigJava, "\u5143\u7d20\u7684key\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return this.queryOnlyOneByKey(element.showKey());
    }

    public int removeByKey(E element) {
        AssertUtil.assertNotFatalProgramConfig(element.showKey() != null, Status.Server.programConfigJava, "\u5143\u7d20\u7684key\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return this.removeByKey(element.showKey());
    }

    public int removeByKey(String key) {
        AssertUtil.assertMethodRequire(key, "key");
        Iterator<E> it = this.storage.iterator();
        int count = 0;
        while (it.hasNext()) {
            StringKeyable element = (StringKeyable)it.next();
            if (!element.matchKey(key)) continue;
            it.remove();
            ++count;
        }
        return count;
    }

    public <K> Optional<E> queryOnlyOneByKey(String key) {
        AssertUtil.assertMethodRequire(key, "key");
        List<StringKeyable> results = this.queryByFilter(key, StringKeyable::showKey);
        return results.stream().findFirst();
    }
}

