/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.mini.framework.util.asserts.AssertUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PinyinUtil {
    private static Logger logger = LogManager.getLogger(PinyinUtil.class);

    public static String toFirstPinyin(String name) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        String result = "";
        AssertUtil.assertMethodRequire(name, "name");
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            String[] pys = null;
            try {
                pys = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                logger.debug("\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            }
            if (pys != null && pys.length > 0) {
                String py = pys[0];
                result = result + py.substring(0, py.length() - 1);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                result = result + String.valueOf(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            result = result + String.valueOf(c);
        }
        result = result.toUpperCase();
        return result;
    }
}

