/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.bean;

import com.google.gson.Gson;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.JsonEditUtil;
import com.mini.framework.util.string.StringUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class GsonStringNodeFormatItem {
    private String[] paths;
    private Boolean urlEncode;

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public Boolean getUrlEncode() {
        return this.urlEncode;
    }

    public void setUrlEncode(Boolean urlEncode) {
        this.urlEncode = urlEncode;
    }

    public GsonStringNodeFormatItem() {
    }

    public GsonStringNodeFormatItem(Boolean urlEncode, String ... paths) {
        this.urlEncode = urlEncode;
        this.paths = paths;
    }

    private static String removePreSuffix(String input, String match) {
        String suffix = StringUtils.substringAfter((String)input, (String)match).substring(1);
        String prefix = StringUtils.substringBefore((String)input, (String)match);
        prefix = prefix.substring(0, prefix.length() - 1);
        return prefix + match + suffix;
    }

    public String decode(String input) {
        String match = JsonEditUtil.getJsonMapNamespaceValue(input, this.paths);
        if (match == null) {
            return input;
        }
        if (match.length() == 0) {
            return input;
        }
        if (this.urlEncode != null && this.urlEncode.booleanValue()) {
            String beanValue = StringUtil.urlDecode(match);
            String stringValue = GsonStringNodeFormatItem.toGsonElementString(beanValue);
            input = StringUtils.replaceOnce((String)input, (String)match, (String)stringValue);
        }
        match = JsonEditUtil.getJsonMapNamespaceValue(input, this.paths);
        input = GsonStringNodeFormatItem.removePreSuffix(input, GsonStringNodeFormatItem.toGsonElementString(match));
        input = StringUtils.replaceOnce((String)input, (String)GsonStringNodeFormatItem.toGsonElementString(match), (String)match);
        return input;
    }

    private static String toGsonElementString(String input) {
        AssertUtil.assertMethodRequire(input, "input");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", input);
        String json = GsonStringNodeFormatItem.createGson().toJson(map);
        String result = json.substring(6, json.length() - 2);
        return result;
    }

    private static Gson createGson() {
        return GsonUtil.createBaseBuilder().create();
    }
}

