/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.thread;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.aspect.AspectBeanUtil;
import com.mini.framework.util.function.FinderStream;
import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MethodTracePointer;
import com.mini.framework.util.thread.HaveCurrSiteable;
import com.mini.framework.util.thread.ObjectThreadCachable;
import com.mini.framework.util.thread.ThreadSiteKey;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class AsyncThreadMsgHandler {
    @Pointcut(value="@annotation(com.mini.framework.util.thread.ThreadAutoFollowMsg)")
    public void methodPointcut() {
    }

    @Before(value="methodPointcut()")
    public void autoFollowMsg(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        this.getMethodTracePointer().autoPoint(targetMethod);
        Object siteKey = FinderStream.requireNotNull(new Object()).nextOptional(() -> AspectBeanUtil.queryParamByAnnotation(joinPoint, ThreadSiteKey.class).map(o -> o)).nextOptional(() -> AspectBeanUtil.queryParamByClass(joinPoint, HaveCurrSiteable.class).map(HaveCurrSiteable::getCurrSiteId)).find().orElseThrow(() -> new ServerException(Status.Server.programConfigJava, "\u6ca1\u6709\u4ece\u7ebf\u7a0b\u4e2d\u5f97\u5230\u5546\u5bb6id\u9700\u8981\u68c0\u67e5java\u65b9\u6cd5:%s", new Object[]{AspectBeanUtil.getMethod(joinPoint)}));
        this.getLocalThreadSiteId().set(String.valueOf(siteKey));
        LinkTraceFace.markSiteId(String.valueOf(siteKey));
    }

    public abstract ObjectThreadCachable<String> getLocalThreadSiteId();

    public abstract MethodTracePointer getMethodTracePointer();
}

