package com.mini.framework.util.alert;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;

import com.mini.framework.util.aspect.AspectBeanUtil;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.log.trace.MethodTracePointer;

//@Aspect  
//@Component 
public class AopLogUtil {
	
	@Autowired
	private MethodTracePointer methodTracePointer;
	
	private Logger logger = LogManager.getLogger(AopLogUtil.class);
	
	//这里记得用||而不是and测试过了，and居然只有第一个生效
	/*    @Pointcut("execution(* com.aquke.study.dao..*.update*(..)) || "
    		+ "execution(* com.aquke.study.dao..*.insert*(..)) || "
    		+ "execution(* com.aquke.study.dao..*.delete*(..))"
    		)  */
    @Pointcut("@annotation(org.apache.ibatis.annotations.DeleteProvider) || "
    		+ "@annotation(org.apache.ibatis.annotations.UpdateProvider) || "
    		+ "@annotation(org.apache.ibatis.annotations.InsertProvider) || "
    		+ "@annotation(org.apache.ibatis.annotations.Delete) || "
    		+ "@annotation(org.apache.ibatis.annotations.Update) || "
    		+ "@annotation(org.apache.ibatis.annotations.Insert)"
    		) 
    public void dbWritePointcut(){}
    
    @AfterReturning(pointcut = "dbWritePointcut()",returning="result")
    public void dbWrite(JoinPoint joinPoint,Object result){
    	String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
    	logger.log(MiniLogLevel.getKeyBizLog(), "database-write,result:{},on {}",result,info);
    }
    
    
    @AfterThrowing(pointcut = "dbWritePointcut()",throwing="exception")
    public void dbWrite(JoinPoint joinPoint,Throwable exception){
		String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
		logger.log(MiniLogLevel.getKeyBizLog(), "database-write-exception:{} on execute {}",exception.getMessage(),info);
    }
    
    
}
