package com.mini.framework.util.asserts;

/**
 * 类型需求，一般用于断言<br>
 * @author jayheo
 *
 */
public enum Require {
	
	/**
	 * 去掉前后空格后不能为空
	 */
	trimNotEmpty("不能为空"),
	
	/**
	 * 数组长度
	 * 在使用 @judge 参数应该传到params里
	 */
	arrLength("长度必须为:%s"),
	/**
	 * 必须相等
	 */
	equals("必须相等"),
	/**
	 * 不是空指针
	 */
	notNull("不能空指针"),
	
	/**
	 * 不是空  空: ""
	 */
	notEmpty("不能为空"),
	
	/**
	 * 表达是结果为true
	 * */
	isTrue("必须为true"),
	
	/**
	 * 值得介于两种间
	 * 遵循左闭右开原则
	 */
	between("必须介于两者之间"),
	
	/**
	 * 手机格式
	 */
	mobileFormat("必须是手机号"),
	
	/**
	 * openId格式
	 */
	openIdFormat("必须openId格式"),
	
	/**
	 * email格式
	 */
	emailFormat("必须是邮件格式"),
	/**
	 * phone格式
	 */
	phone("必须是手机格式"),
	
	/**
	 * 是数字
	 */
	isNumber("必须是数字");
	
	private String notice;
	
	Require(String notice) {
		this.notice = notice;
	}

	public String getNotice() {
		return notice;
	}
}
