package com.mini.framework.util.bean;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.mini.framework.core.exception.HandleException;

public class BeanUtil {
	
	/**
	 * 返回类所有的属性，包含父类
	 * @param bean
	 * @return
	 */
	public static List<Field> getAllField(Object bean){
    	List<Field> allField = new ArrayList<>();
    	Class<?>tempClass =  bean.getClass();
    	do{
    		Field[] fields = tempClass.getDeclaredFields();
    		allField.addAll(Arrays.asList(fields));
    		tempClass = tempClass.getSuperclass();
    	}while(tempClass!=null && tempClass!=Object.class);
    	return allField;
	}
	
	public static <T> Map<String, Object> beanToMap(T source) {
		Map<String, Object> result = new LinkedHashMap<>();
		List<Field> sourceFiled = getAllField(source);
		for (Field field : sourceFiled) {
			field.setAccessible(true);// 设置可访问,不然拿不到private
			// 配置了注解的话则使用注解名称,作为header字段
			try {
				result.put(field.getName(), field.get(source));
			} catch (IllegalArgumentException | IllegalAccessException e) {
				throw new HandleException(e,"在取类%s的属性%s时出错", source.getClass(),field);
			}
		}
		return result;
	}

}
