package com.mini.framework.util.colony;


public interface DelayLockHelper {

	/**
	 * 释放锁
	 * @param key
	 */
	void releaseLock(String key);
	

	default void releaseLock(String... keys){
		releaseLock(createKey(keys));
	}
	
	/**
	 * 得到锁
	 * @param delay 锁住的时间
	 * @param key
	 * @return
	 */
	boolean getLock(int delay,String key);
	

	default boolean getLock(int delay,String... keys){
		return getLock(delay, createKey(keys));
	}
	
	
	String createKey(String... params);
}
