package com.mini.framework.util.colony;

import java.util.concurrent.TimeUnit;

import org.redisson.RedissonClient;
import org.redisson.core.RLock;

//ERR command eval not support for normal user.  如果出现这个错误的时候检查redis是不是支持lua
//https://yq.aliyun.com/news/214187

public class RedissonIncDelayLockHelper implements DelayLockHelper{

	private RedissonClient redissonClient;
	
	private String prefix;
	
	private String keySplit = ":";
	
	public RedissonIncDelayLockHelper(RedissonClient redissonClient,String prefix) {
		super();
		this.redissonClient = redissonClient;
		this.prefix = prefix;
	}

	@Override
	public boolean getLock(int delay,String key) {
		key = createKey(prefix, key);
		RLock lock = redissonClient.getLock( key);
		try {
			return lock.tryLock(0, delay, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
			//TODO 睡眠被打断的时候应该阻止获取锁
			return false;
		}
	}

	@Override
	public void releaseLock(String key) {
		key = createKey(prefix, key);
		RLock lock = redissonClient.getLock(key);
		lock.unlock();
	}

	@Override
	public String createKey(String... params) {
		return String.join(keySplit, params);
	}

}
