package com.mini.framework.util.date.bean;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 相对时间
 * 
 * @author jayheo
 *
 */
public class RelativeDate {

	/**
	 * 参照的目标时间
	 */
	private Date referTargetDate;

	/**
	 * 实际的时间
	 */
	private Date actualDate;

	/**
	 * 间隔时间单位毫秒
	 */
	private Long intervalTime;

	/**
	 * 间隔的名字
	 */
	private String intervalName;
	
	/**
	 * 代替方案
	 */
	RelativeDateAliasScheme aliasScheme;

	public RelativeDate() {
		super();
	}

	public static  RelativeDate countRelative (RelativeDateAliasScheme aliasScheme,Date referTargetDate,Date actualDate) {
		return new RelativeDate(aliasScheme, referTargetDate, actualDate);
	}
	
	public static  List<RelativeDate> countRelatives (RelativeDateAliasScheme aliasScheme,Date referTargetDate,Stream<Date> actualDates) {
		return actualDates.map(actualDate->countRelative(aliasScheme, referTargetDate, actualDate)).collect(Collectors.toList());
	}
	
	public static <D>  List<RelativeDate> countRelatives (RelativeDateAliasScheme aliasScheme,Date referTargetDate,List<D> actualDates,Function<D, Date> dateGetter) {
		return countRelatives(aliasScheme, referTargetDate,actualDates.stream().map(dateGetter));
	}
	

	public static  Map<RelativeDateAliasScheme, RelativeDate> countRelative (Date referTargetDate,Date actualDate,RelativeDateAliasScheme... aliasSchemes) {
		Map<RelativeDateAliasScheme, RelativeDate> mapper = new HashMap<>();
		for (RelativeDateAliasScheme aliasScheme : aliasSchemes) {
			mapper.put(aliasScheme, new RelativeDate(aliasScheme, referTargetDate, actualDate));
		}
		return mapper;
	}
	
	public static  List<Map<RelativeDateAliasScheme, RelativeDate>> countRelatives (Date referTargetDate,Stream<Date> actualDates,RelativeDateAliasScheme... aliasSchemes) {
		return actualDates.map(actualDate->countRelative( referTargetDate, actualDate,aliasSchemes)).collect(Collectors.toList());
	}
	
	public static <D>  List<Map<RelativeDateAliasScheme, RelativeDate>> countRelatives (Date referTargetDate,List<D> actualDates,Function<D, Date> dateGetter,RelativeDateAliasScheme... aliasSchemes) {
		return countRelatives( referTargetDate,actualDates.stream().map(dateGetter),aliasSchemes);
	}
	
	public RelativeDate(RelativeDateAliasScheme aliasScheme,Date referTargetDate,Date actualDate) {
		super();
		AssertUtil.assertMethodRequire(actualDate, "actualDate");
		AssertUtil.assertMethodRequire(aliasScheme, "aliasScheme");
		AssertUtil.assertMethodRequire(referTargetDate, "referTargetDate");
		this.aliasScheme = aliasScheme;
		this.referTargetDate = referTargetDate;
		this.actualDate = actualDate;
		this.intervalTime = actualDate.getTime() - referTargetDate.getTime();
		this.intervalName = aliasScheme.countRelativeName(this.intervalTime);
	}



	public Date getReferTargetDate() {
		return referTargetDate;
	}

	public void setReferTargetDate(Date referTargetDate) {
		this.referTargetDate = referTargetDate;
	}

	public Date getActualDate() {
		return actualDate;
	}

	public void setActualDate(Date actualDate) {
		this.actualDate = actualDate;
	}

	public Long getIntervalTime() {
		return intervalTime;
	}

	public void setIntervalTime(Long intervalTime) {
		this.intervalTime = intervalTime;
	}

	public String getIntervalName() {
		return intervalName;
	}

	public void setIntervalName(String intervalName) {
		this.intervalName = intervalName;
	}
	
	public RelativeDateAliasScheme getAliasScheme() {
		return aliasScheme;
	}

	public void setAliasScheme(RelativeDateAliasScheme aliasScheme) {
		this.aliasScheme = aliasScheme;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	

}
