package com.mini.framework.util.export.protocol;

import com.mini.framework.core.exception.HandleReflectException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.generic.define.OptionalObject;


/**
 * excel 单元的内容提供者
 * @author jayheo
 */
public interface ExcelCellContentSupplier {

    /**
     * 提供内容
     * TODO 这里需要确认一下，不填和填  长度为0的字符串是不是同一个意思
     * @param originOptional 原始内容
     * @return
     */
    default String supplier(OptionalObject originOptional){
        return originOptional.out().map(this::supplier).orElse("");
    }


    /**
     * 断言不能为空
     * @param target
     * @param <T>
     * @return
     */
    default <T> T assertNotNull(T target){
        AssertUtil.assertMethodRequire(target,"target");
        return target;
    }


    /**
     * 根据给定的值提供内容
     * @param origin
     * @return
     */
    String supplier(Object origin);


    /**
     * 创建实例
     * @param supplierClass
     * @return
     */
    static ExcelCellContentSupplier createInstance(Class<? extends ExcelCellContentSupplier> supplierClass){
        try {
            return supplierClass.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            throw new HandleReflectException(e,"根据类:[%s]创建实例出错",supplierClass);
        }
    }

}
