package com.mini.framework.util.file;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import com.mini.framework.core.exception.standard.UnsupportedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.cache.HoldSupplier;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.core.exception.HandleIOException;

/**
 * jar包工具类
 * @author jayheo
 *
 */
public class JarUtil {
	
	private static Logger logger = LogManager.getLogger(JarUtil.class);

	private static final String springBuildVersionKey = "Implementation-Version";
	
	
	private static final String metaInfPath = "META-INF"   + File.separator+ "MANIFEST.MF";
	

	private static HoldSupplier<Map<String, String>> metaInfosSupplier = HoldSupplier.create(()->readCurrentRunJarMetaInfos());
	
	/**
	 * 读jar文件中的配置
	 * @param jarFile
	 * @param path
	 * @return
	 */
	public static Map<String, String> readprops(String jarFile, String path){
		//TODO @NotNull 还没有验证没有效果，后面要找时间验证一下。
		Map<String,String> props = new LinkedHashMap<String, String>();
		JarFile jar = null;
		try {
			jar = new JarFile(jarFile);
			JarEntry entry = jar.getJarEntry(path);
			List<String> lines = IOUtils.readLines(jar.getInputStream(entry),"utf-8");
			lines.stream().filter(line->line!=null).forEach(line->{
				String[] keyValue = line.split(": ");
				props.put(keyValue[0],keyValue.length>1?keyValue[1]:null);
			});
		} catch (IOException e) {
			throw new HandleIOException(e,"处理jar:[%s]文件出错", jarFile);
		}finally{
			IOUtils.closeQuietly(jar);
		}
		return props;
	}
	
	/**
	 * 得到前运行的jar的meta info
	 * @return
	 */
	public static Map<String, String> readCurrentRunJarMetaInfos(){
		return readMetaInfos(getCurrentRunJar());
	}
	
	public static Map<String, String> readMetaInfos(String jarFile){
		return readprops(jarFile, metaInfPath);
	}
	
	public static String getCurrentRunJar(){
		String jarPath = JarUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
		//file:/D:/work/java/work11/tdt-api/tdt-bi/target/tdt-bi-1.0.0.jar!/BOOT-INF/lib/framework-util-1.0.6.4-SNAPSHOT.jar!/
		logger.log(MiniLogLevel.getFrameWorkLog(), "jarPath:",jarPath);
		jarPath = StringUtils.substringBetween(jarPath, ":", "!");
		logger.log(MiniLogLevel.getFrameWorkLog(), "filePath:",jarPath);
		return Optional.of(jarPath).orElseThrow(()->new UnsupportedException("暂时不支持找不到当前运行的jar名字"));
	}

	
	/**
	 * 得到当前运行的jar版本
	 * @return
	 */

	public static String currentRunJarStringBuildVersion(){
		String version = metaInfosSupplier.get().get(springBuildVersionKey);
		return version;
	}
	
	
	public static String currentRunJarStringBuildVersion(int hourAdd){
		String version = currentRunJarStringBuildVersion();
		if(hourAdd!=0 && version!=null){
			//TODO 这里弄时区还有点问题要处理一下。
			String hour = StringUtils.substringAfterLast(version, "-");
			int intHour = Integer.parseInt(hour);
			intHour = (intHour + hourAdd)%24;
			version = StringUtils.substringBeforeLast(version, "-" ) + "-" + StringUtils.leftPad(String.valueOf(intHour), 2, "0");
		}
		return version;
	}
	
}
