package com.mini.framework.util.log.trace;

import java.lang.reflect.Method;

public class MethodTracePointer {
	
	private MethodFeatureCache methodFeatureCache;
	
	private MethodFeatureResolver methodFeatureResolver = new SimpleMethodFeatureResolver();
	
	public void setMethodFeatureResolver(MethodFeatureResolver methodFeatureResolver) {
		this.methodFeatureResolver = methodFeatureResolver;
	}
	
	public MethodTracePointer(MethodFeatureCache methodFeatureCache){
		this.methodFeatureCache = methodFeatureCache;
	}
	

	/**
	 * 
	 * 自动导入特征，这个方法会去找到调用者，这个方法不稳定，可能受动态代理的影响。
	 */
	public void autoPoint(){
		autoPoint(3);
	}

	/**
	 * 自动导入特征，这个方法会去找到调用者，这个方法不稳定，可能受动态代理的影响。
	 * @param preIndex
	 * @return
	 */
	public void autoPoint(int preIndex){
		//这里对于aop等东西还是没有抓到最原始的方法。
		StackTraceElement proMethod = Thread.currentThread().getStackTrace()[preIndex];
		String classPath = proMethod.getClassName();
		String name = proMethod.getMethodName();
		int line = proMethod.getLineNumber();
		String feature = String.format("%s.%s() line:%s",classPath,name, line);
		String traceId = methodFeatureCache.loadFeature(feature);
		LinkTraceFace.linkBeginPoint(traceId);
	}
	/**
	 * 自动导入特征
	 * @param method
	 * @return
	 */
	public void autoPoint(Method method){
		String feature = methodFeatureResolver.resolveFeature(method);
		String traceId = methodFeatureCache.loadFeature(feature);
		LinkTraceFace.linkBeginPoint(traceId);
	}
	
	/**
	 * 主动清除跟踪
	 */
	public void endTrace(){
		LinkTraceFace.clearTrace();
	}
}
