package com.mini.framework.util.log.trace;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public class SimpleMethodFeatureResolver implements MethodFeatureResolver{

	@Override
	public String resolveFeature(Method method) {
		String classPath = method.getDeclaringClass().getName();;
		String name = method.getName();
		Class<?>[] types = method.getParameterTypes();
		List<String> typeNames = new ArrayList<String>();
		for (Class<?> type : types) {
			typeNames.add(type.getName());
		}
		String args = StringUtils.join(typeNames, ",");
		String feature = String.format("%s.%s(%s)",classPath,name, args);
		return feature;
	}

}
