package com.mini.framework.util.optional;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 可能的 set integer
 * */
@Deprecated
public class OptionalSetInteger extends OptionalSet<Integer>{


    private static final OptionalSetInteger createEmpty (){
        return new OptionalSetInteger();
    }


    public static OptionalSetInteger ofNullable(Collection<Integer> collInteger){
        return collInteger==null?  createEmpty() :of(collInteger);
    }


    /**
     * 从集合中取出来
     * */
    public static OptionalSetInteger of(Collection<Integer> collInteger){
        OptionalSetInteger set = new OptionalSetInteger();
        set.value = new LinkedHashSet<>(collInteger);
        Objects.requireNonNull(collInteger,"collInteger不能为空").stream().map(t->set.add(t));
        return set;
    }

    public static OptionalSetInteger ofNullable(Integer... ts){
        return ts==null?  createEmpty() :of(ts);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalSetInteger of(Integer... ts){
        return of(Stream.of(ts).collect(Collectors.toSet()));
    }


    public static OptionalSetInteger ofNullable(String arr){
        return arr==null? createEmpty() :of(arr);
    }

    public static OptionalSetInteger of(String arr){
        String[] integers = arr.split(",");
        List<Integer> list = Stream.of(arr.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        return of(list);
    }

    public Optional<Set<Integer>> out(){
        return out(false);
    }

    public Optional<Set<Integer>> outNotZero(){
        return out(true);
    }

    public Optional<Set<Integer>> out(boolean zeroAsNull){
        if(zeroAsNull && (value!=null&& value.isEmpty())){
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }


    @Override
    public String toString() {
        return out().toString();
    }

}
