package com.mini.framework.util.oss.bean;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;









import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.OssPicUtil;
import com.mini.framework.util.oss.OssWatermarkUtil;
import com.mini.framework.util.oss.bean.offset.GridOffsetWaterMarkNumber;
import com.mini.framework.util.oss.bean.offset.JiugePalaceOffsetWaterMarkType;


// http://image-demo.oss-cn-hangzhou.aliyuncs.com/example.jpg?x-oss-process=image/resize,w_200/blur,r_3,s_2

public class OssImageProcessParams  {

	private String action;

	private Map<String, String> params;
	
	private OssImageProcessParams nextsProcess;
	
	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public Map<String, String> getParams() {
		return params;
	}
	

	public OssImageProcessParams paramIfVal(String key,Object value) {
		if(value!=null){
			param(key, String.valueOf(value));
		}
		return this;
	}
	
	public OssImageProcessParams param(String key,int value) {
		return param(key, String.valueOf(value));
	}
	
	/**
	 * 填入没有值的参数
	 * @param key
	 * @return
	 */
	public OssImageProcessParams param(String key) {
		return param(key, null);
	}
	
	/**
	 * 添加xy的参数值
	 * @param x
	 * @param y
	 * @return
	 */
	public OssImageProcessParams paramXy(int x,int y) {
		return param("x", x).param("y", y);
	}
	
	public OssImageProcessParams paramXyIfVal(Integer x,Integer y) {
		return paramIfVal("x", x).paramIfVal("y", y);
	}

	
	public OssImageProcessParams paramWhIfVal(Integer w,Integer h) {
		return paramIfVal("w", w).paramIfVal("h", h);
	}
	
	public OssImageProcessParams paramWh(int w,int h) {
		return param("w", w).param("h", h);
	}
	
	public OssImageProcessParams paramBase64(String key,String value) {
		return param(key,OssWatermarkUtil.urlSafeBase64(value));
	}
	
	
	public OssImageProcessParams param(String key,String value) {
		AssertUtil.assertMethodRequire(key, "key");
		params.put(key, value);
		return this;
	}
	
	public OssImageProcessParams(String action,String key,String value) {
		this(action);
		param(key, value);
	}
	public OssImageProcessParams(String action,String key,int value) {
		this(action);
		param(key, value);
	}
	
	public OssImageProcessParams(String action,String key,String value,String key1,String value1) {
		this(action,key,value);
		param(key1, value1);
	}
	public OssImageProcessParams(String action,String key,int value,String key1,int value1) {
		this(action,key,value);
		param(key1, value1);
	}
	

	public static OssImageProcessParams create(String action) {
		return new OssImageProcessParams(action);
	}
	
	public OssImageProcessParams(String action) {
		super();
		AssertUtil.assertMethodRequire(action, "action");
		this.action = action;
		params = new LinkedHashMap<String, String>();
	}
	
	//TODO 这里的逻辑稍微有一点点不是很清晰，需要再优化一下
	public String applyParams(String url){
		AssertUtil.assertMethodRequire(url, "url");
			String split = url.contains("?") ? "&":"?";
			String process = url.contains("x-oss-process=image") ? "": (split+ "x-oss-process=image");
			url += process ;
		//}
		url += "/" + action;
		url += params.entrySet().stream().map(e->e.getKey() +( e.getValue()==null?"":( "_" + e.getValue()))).reduce("", (a,b)->a + "," + b);
		if(nextsProcess!=null){
			url = nextsProcess.applyParams(url);
		}
		return url;
	}
	
	public static String applyMultiParams(String url,OssImageProcessParams... opps){
		return applyMultiParams(url, Arrays.asList(opps));
	}
	
	public static String applyMultiParams(String url,List<OssImageProcessParams> opps){
		AssertUtil.assertMethodRequire(url, "url");
		for (int i = 0; i < opps.size(); i++) {
			OssImageProcessParams opp = opps.get(i);
			url = opp.applyParams(url);
		}
		return url;
	}
	
	public static OssImageProcessParams linkMultiParams(List<OssImageProcessParams> opps){
		AssertUtil.assertMethodRequire(opps, "opps");
		AssertUtil.assertSupport(opps.size()>0, "opps不能为空");
		OssImageProcessParams first = opps.stream().findFirst().get();
		if(opps.size()>1){
			first.andThenMultiParams(opps.get(1));
			linkMultiParams(opps.subList(1, opps.size()));
		}
		return first;
	}
	
	public OssImageProcessParams andThenMultiParams(OssImageProcessParams next){
		nextsProcess = next;
		return this;
	}
	
	
	public static OssImageProcessParams linkMultiParams(OssImageProcessParams... opps){
		return linkMultiParams( Arrays.asList(opps));
	}
	
	
	/**
	 * 横向切割
	 * TODO 不能大于4096
	 * @param offset 切割的起点，从上向下数像素
	 * @param limit 切割的高度 从上向下数像素
	 * @param width 从左边算起保留宽度
	 * @return
	 */
	public static OssImageProcessParams crossCutProcess (int offset,int limit,int width){ 
		return crossCutProcess(true, offset, limit, width);
	}
	
	
	/**
	 * TODO 不能大于4096
	 * @param down 是不是从上向下
	 * @param offset 切割的起点，从上向下数像素
	 * @param limit 切割的高度 从上向下数像素
	 * @param width 从左边算起保留宽度
	 * @return
	 */
	public static OssImageProcessParams crossCutProcess (boolean down, int offset,int limit,int width){ 
		String pParam = down?"nw":"sw";
		return new OssImageProcessParams("crop","g",pParam)//以左上为起点
		.param("x",0).param("w",width)//指定横向起止，因为是横切直接是从头到尾了。
		.param("y",offset).param("h",limit);//指定纵向起止。由offset和limit决定。
	}
	
	
	/**
	 * 横向向下打图片水印
	 * @param watermarkPath 水印资源的位置
	 * @param offset 从上向下偏移的量;  也就是以底为参照他的起点
	 * @param transparent 透明度，也就是透明度[0,100] 0表示（不透明）
	 * @return
	 */
	public static OssImageProcessParams crossDownImageWatermarkProcess (String watermarkPath ,int offset,int transparent){ 
		String watermarkPathBase64 = OssWatermarkUtil.urlSafeBase64(watermarkPath);
		int covered = 100-transparent;//不透明度
		return new OssImageProcessParams("watermark","image",watermarkPathBase64 )
		.param("g","north")//北边，也就是从下向下偏移
		.param("y",offset )//从上向下偏移的量;  这个值要越来越大
		.param("t", covered)//透明度[0,100]， 100表示 100%（不透明） 这个值要越来越小
		;
	}
	
	//https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1299.7745c1f6idUvAf
	public static OssImageProcessParams imageWatermark(MapDirection direction ,String watermarkPath,Integer xoffset,Integer yoffset){
		AssertUtil.assertMethodRequire(direction, "direction");
		AssertUtil.assertMethodRequire(watermarkPath, "watermarkPath");
		String watermarkPathBase64 = OssWatermarkUtil.urlSafeBase64(watermarkPath);
		return new OssImageProcessParams("watermark","image",watermarkPathBase64 )
		.param("g", direction.name()).param("x", xoffset).param("y", yoffset);
	}
	
	
	//https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1299.7745c1f6idUvAf
	public static OssImageProcessParams imageNwWatermark(String watermarkPath,Integer xoffset,Integer yoffset){
		return imageWatermark(MapDirection.nw, watermarkPath, xoffset, yoffset);
	}
	
	//https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1299.7745c1f6idUvAf
	/**
	 * 
	 * @param content
	 * 
	 * 
	 * 
	 * @param xoffset
	 * @param yoffset
	 * @param color
	 * 参数意义：文字水印文字的颜色
参数的构成必须是：六个十六进制数，如：000000表示黑色。 000000每两位构成RGB颜色， FFFFFF表示的是白色
默认值：000000黑色
	 * @param size
	 * 参数意义：文字水印文字大小(px)
取值范围：(0，1000]
默认值：40
	 * @param type  
	 * https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1298.32783168l2lTsg
默认值：wqy-zenhei
	 * @param shadow
	 * 参数意义：文字水印的阴影透明度
取值范围：(0,100]
	 * @param rotate
	 * 参数意义：文字顺时针旋转角度
取值范围：[0,360]
	 * @return
	 */
	public static OssImageProcessParams textNwWatermark(String content,int xoffset,int yoffset,String color,int size,String type,int shadow,int rotate){
		String contentBase64 = OssWatermarkUtil.urlSafeBase64(content);
		return new OssImageProcessParams("watermark","text",contentBase64 )
		.param("g", "nw").param("x", xoffset).param("y", yoffset)
		.param("type",OssWatermarkUtil.urlSafeBase64(type))
		.param("color", color).param("size", size).param("shadow", shadow).param("rotate", rotate)
		;
	}
	
	
	/**
	 * https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1301.493e4ecdXSbRTp
	 * 文档上说了，水印的 图片裁剪（不支持内切圆)
	 * 如果碰到这个需求要走 circleByRoundedCorners 效果是一样的
	 * 通过半径切一个圆出来
	 * @param path
	 * @param radius
	 * @return
	 */
	public static String circleByRadius (String url ,int radius){ 
		return circleByRadius(radius).applyParams(url);
	}
	
	
	/**
	 * https://help.aliyun.com/document_detail/44957.html?spm=a2c4g.11186623.6.1301.493e4ecdXSbRTp
	 * 文档上说了，水印的 图片裁剪（不支持内切圆)
	 * 如果碰到这个需求要走 circleByRoundedCorners 效果是一样的
	 * 通过半径切一个圆出来
	 * @param path
	 * @param radius
	 * @return
	 */
	public static OssImageProcessParams circleByRadius (int radius){ 
		//mfit：等比缩放，延伸出指定w与h的矩形框外的最小图片。
		OssImageProcessParams resize = new OssImageProcessParams("resize","w",radius*2,"h",radius*2).param("m", "mfit");
		OssImageProcessParams circle = new OssImageProcessParams("circle").param("r",radius);
		OssImageProcessParams format = formatProcess("png");
		return linkMultiParams(resize,circle,format);
	}
	
	
	public static String circleByRoundedCorners (String url ,int radius){ 
		return circleByRoundedCorners(radius).applyParams(url);
	}
	
	/**
	 * 通过圆角来切一个圆出来
	 * @param path
	 * @param radius
	 * @return
	 */
	public static OssImageProcessParams circleByRoundedCorners (int radius){ 
		//fill：固定宽高，将延伸出指定w与h的矩形框外的最小图片进行居中裁剪。
		OssImageProcessParams resize = new OssImageProcessParams("resize","w",radius*2,"h",radius*2).param("m", "fill");
		//crop,w_200,h_200,x_0,y_0,g_center
		OssImageProcessParams crop = new OssImageProcessParams("crop","w",radius*2,"h",radius*2).paramXy(0, 0).param("g", "center");
		OssImageProcessParams circle = new OssImageProcessParams("rounded-corners").param("r",radius);
		OssImageProcessParams format = formatProcess("png");
		return linkMultiParams(resize, crop,circle,format);
	}
	
	/**
	 * 将图片切出圆角，指定圆角的半径。
	 * @param radius
	 * @return
	 */
	public static OssImageProcessParams roundedCornersProcess (int radius){ 
		OssImageProcessParams rounded = new OssImageProcessParams("rounded-corners").param("r",radius);
		OssImageProcessParams format = formatProcess("png");
		return linkMultiParams(rounded,format);
	}
	

	/**
	 * 得到图片格式化的图片处理过程(修改图片的过程)
	 * @param format 目标格式
	 * @return
	 */
	public static OssImageProcessParams formatProcess(String format) {
		AssertUtil.assertMethodRequire(format, "format");
		//TODO 检查支持的格式
		return new OssImageProcessParams("format").param(format);
	}
	

	/**
	 * 格式化的图片处理
	 * @param format 目标格式
	 * @param ossUrl 待处理的url
	 * @return
	 */
	public static String formatSpecial(String format,String ossUrl) {
		return formatProcess(format).applyParams(ossUrl);
	}

	/**
	 * 得到图片webp格式化的图片处理过程(修改图片的过程)
	 * @return
	 */
	public static OssImageProcessParams formatWebpProcess() {
		return new OssImageProcessParams("format").param("webp");
	}

	/**
	 * webp格式化的图片处理
	 * @param ossUrl 待处理的url
	 * @return
	 */
	public static String formatWebp(String ossUrl) {
		return formatWebpProcess().applyParams(ossUrl);
	}
	

	/**
	 * 使用网格添加水印
	 * 如果要使用这个方法要求保证 postUrl 和 watermarkPath在同一个ossbucket，且postUrl是一个正常的url，watermarkPath是一个正常的oss路径。
	 * @param postUrl 被添加水印的海报 
	 * @param watermarkPath 水印的路径
	 * @param widthSize 水印定位之海报宽度
	 * @param widthFrom 水印定位之水印宽起点
	 * @param widthTo 水印定位之水印宽结束点
	 * @param heightSize 水印定位之海报高度
	 * @param heightFrom  水印定位之水印高起点
	 * @param heightTo 水印定位之水印高结束点
	 * @return
	 */
	public static String watermarkAsGrid(String postUrl,String watermarkPath,int widthSize,int widthFrom,int widthTo,int heightSize,int heightFrom,int heightTo){
		final MapDirection defaultMapDirection = MapDirection.se;
		final MapDirection direction =  defaultMapDirection;
		AssertUtil.assertNoBadReq(widthFrom>=0 && heightFrom>=0, Status.BadReq.illParam, "水印的宽:[%s]高:[%s]起点必须大于等于0", widthFrom,heightFrom);
		AssertUtil.assertNoBadReq(widthFrom<=widthTo && heightFrom<=heightTo, Status.BadReq.illParam, "水印的宽起点:[%s]和高起点:[%s]不能大于宽:[%s]止点和高:[%s]止点"
				, widthFrom, heightFrom,widthTo ,heightTo);
		AssertUtil.assertNoBadReq(widthSize>=widthTo && heightSize>=heightTo, Status.BadReq.illParam, "水印的宽size:[%s]和高size:[%s]不能小于宽:[%s]止点和高:[%s]止点"
				, widthSize, heightSize,widthTo ,heightTo);
		PicInfo info = OssPicUtil.findBaseInfo(postUrl);
		int posterWidth = info.getWidth();
		int posterHeight = info.getHeight();
		int xFrom = Math.round(posterWidth * (1.0f*widthFrom/widthSize));
		int yFrom =Math.round( posterHeight * (1.0f*heightFrom/heightSize));
		
		int xLimit = Math.round(posterWidth * (1.0f*(widthTo-widthFrom)/widthSize));
		int yLimit  =Math.round( posterHeight * (1.0f*(heightTo-heightFrom)/heightSize));
		watermarkPath = new OssImageProcessParams("resize","m","lfit").paramWh(xLimit, yLimit).applyParams(watermarkPath);
		
		return imageWatermark(direction, watermarkPath
				, direction.countWeFromPoint(posterWidth, xFrom, xLimit).orElse(null)
				, direction.countNsFromPoint(posterHeight, yFrom, yLimit).orElse(null)
				).applyParams(postUrl);
	}

	/**
	 * 使用九宫格位置弄水印
	 * 如果要使用这个方法要求保证 postUrl 和 watermarkPath在同一个ossbucket，且postUrl是一个正常的url，watermarkPath是一个正常的oss路径。
	 * @param ossUrl
	 * @param watermark
	 * @param offset
	 * @return
	 */
	public static String watermarkJiuge(String postUrl,String watermarkPath, JiugePalaceOffsetWaterMarkType offset) {
		AssertUtil.assertMethodRequire(offset, "offset");
		return watermarkAsGrid(postUrl, watermarkPath, 3, offset.getWeIndex(), offset.getWeIndex() + 1
				, 3, offset.getNsIndex(), offset.getNsIndex()+1 );
	}

	/**
	 * 使用预置网格配置做水印
	 * 如果要使用这个方法要求保证 postUrl 和 watermarkPath在同一个ossbucket，且postUrl是一个正常的url，watermarkPath是一个正常的oss路径。
	 * @param postUrl
	 * @param watermarkPath
	 * @param offset
	 * @return
	 */
	public static String watermarkAsGrid(String postUrl, String watermarkPath,GridOffsetWaterMarkNumber offset){
		AssertUtil.assertMethodRequire(offset, "offset");
		return watermarkAsGrid(postUrl, watermarkPath, offset.getWs(), offset.getWf(), offset.getWt(), offset.getHs(), offset.getHf(), offset.getHt());
	}
	
	/**
	 *  如果要使用这个方法要求保证 postUrl 和 watermarkPath在同一个ossbucket，且postUrl是一个正常的url，watermarkPath是一个正常的oss路径。
	 * @param postUrl
	 * @param watermarkPath
	 * @param widthFrom
	 * @param widthTo
	 * @param heightFrom
	 * @param heightTo
	 * @return
	 */
	public static String watermarkAsGridPercent(String postUrl,String watermarkPath,int widthFrom,int widthTo,int heightFrom,int heightTo){
		return watermarkAsGrid(postUrl, watermarkPath, 100, widthFrom, widthTo, 100, heightFrom, heightTo);
	}
	
	
	/**
	 * 按短边缩放后居中裁剪
	 * @param width
	 * @param height
	 * @return
	 */
	public static OssImageProcessParams resizeThenCenterCut(int width,int height,boolean reduceByLimit){
		int limit = 4096;
		if(reduceByLimit){
			int max = Math.max(width, height);
			if(max > limit){
				width = Math.min(limit,width * limit / max);
				height = Math.min(limit,height * limit / max);
			}
		}
		AssertUtil.assertNoBadReq(width<=limit, Status.BadReq.illParam, "阿里云图片处理resize约束width(w):[%s]不能大于:[%s]",width,limit);
		AssertUtil.assertNoBadReq(height<=limit, Status.BadReq.illParam, "阿里云图片处理resize约束height(h):[%s]不能大于:[%s]",height,limit);
		return OssImageProcessParams.create("resize").param("m","fill").paramWh(width,height);
	}
	
	
	/**
	 * 按短边缩放后居中裁剪
	 * @param width
	 * @param height
	 * @return
	 */
	public static OssImageProcessParams resizeThenCenterCut(int width,int height){
		return resizeThenCenterCut(width, height, false);
	}
	
	
}
