package com.mini.framework.util.oss.bean.work.mark;

import java.util.Optional;
import java.util.function.Function;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.OssImageWork;
import com.mini.framework.util.oss.bean.work.type.OriginType;

/**
 * 水印图片处理
 * @author jayheo
 *
 */
public abstract class MarkOssImageWork extends OssImageWork{
	
	/**
	 * <pre>
参数意义：透明度, 如果是图片水印，就是让图片变得透明，如果是文字水印，就是让水印变透明。
默认值：100， 表示 100%（不透明）
取值范围: [0-100]
	 * </pre>
	 */
	@Desc("水印透明度[0-100] 100%（不透明）")
	private Integer transparent;
	
	
	/**
	 * <pre>
参数意义：位置，水印打在图的位置，详情参考下方区域数值对应图。
取值范围：[nw,north,ne,west,center,east,sw,south,se]
</pre>
	 */
	@Desc("位置参考依据")
	private OriginType  origin;
	
	

	/**<pre>
参数意义：垂直边距, 就是距离图片边缘的垂直距离， 这个参数只有当水印位置是左上，中上， 右上，左下，中下，右下才有意义
默认值：10

取值范围：[0 – 4096]

单位：像素(px)
</pre>
	 */
	@Desc("垂直边距, 就是距离图片边缘的垂直距离， 这个参数只有当水印位置是左上，中上， 右上，左下，中下，右下才有意义")
	private Integer yoffset;
	
	
	/**<pre>
参数意义：水平边距, 就是距离图片边缘的水平距离， 这个参数只有当水印位置是左上，左中，左下， 右上，右中，右下才有意义。

默认值：10

取值范围：[0 – 4096]

单位：像素（px）
</pre>
	 */
	@Desc("水平边距, 就是距离图片边缘的水平距离， 这个参数只有当水印位置是左上，左中，左下， 右上，右中，右下才有意义。")
	private Integer xoffset;
	/**<pre>
	参数意义： 中线垂直偏移，当水印位置在左中，中部，右中时，可以指定水印位置根据中线往上或者往下偏移
默认值：0

取值范围：[-1000, 1000]

单位：像素(px)
</pre>
	 */
	@Desc("中线垂直偏移，当水印位置在左中，中部，右中时，可以指定水印位置根据中线往上或者往下偏移")
	private Integer voffset;
	public Integer getTransparent() {
		return transparent;
	}
	public void setTransparent(Integer transparent) {
		this.transparent = transparent;
	}
	public OriginType getOrigin() {
		return origin;
	}
	public void setOrigin(OriginType origin) {
		this.origin = origin;
	}
	public Integer getYoffset() {
		return yoffset;
	}
	public void setYoffset(Integer yoffset) {
		this.yoffset = yoffset;
	}
	public Integer getXoffset() {
		return xoffset;
	}
	public void setXoffset(Integer xoffset) {
		this.xoffset = xoffset;
	}
	public Integer getVoffset() {
		return voffset;
	}
	public void setVoffset(Integer voffset) {
		this.voffset = voffset;
	}
	
	public MarkOssImageWork(){
	}
	
	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket){
		return OssImageProcessParams.create(getOssAction())
				.paramXy(xoffset, yoffset)
				.paramIfVal("t",transparent)
				.paramIfVal("voffset",voffset)
				.paramIfVal("g",Optional.ofNullable(origin).map(OriginType::name).orElse(null))
				;
	}
	public MarkOssImageWork fillParams(Integer transparent, OriginType origin, Integer xoffset, Integer yoffset, Integer voffset) {
		this.transparent = transparent;
		this.origin = origin;
		this.yoffset = yoffset;
		this.xoffset = xoffset;
		this.voffset = voffset;
		return this;
	}
}
