package com.mini.framework.util.params;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.thread.AbstractObjectThreadHold;

/**
 * 线程关键过模糊过滤器
 * @author jayheo
 *
 */
public class ThreadKeywordLikeFilter extends AbstractObjectThreadHold<Map<String, List<String>>>{
	
	private Logger logger = LogManager.getLogger(ThreadKeywordLikeFilter.class);
	
	private Set<String> daoFilters;
	
	public ThreadKeywordLikeFilter(String... daoFilters) {
		super();
		this.daoFilters = new HashSet<>(Arrays.asList(daoFilters));
	}

	/**
	 *  一定要在合适的时候把线程里原来的东西
	 * @param daoFilter
	 * @param keywords
	 * @return
	 */
	public ThreadKeywordLikeFilter filterIfPresent(String daoFilter, String... keywords) {
		this.begin();//TODO 先这样修改了，以后要修改线程工具类
		if(keywords!=null){
			keywords = Stream.of(keywords).filter(Objects::nonNull).filter(k->k.length()>0).collect(Collectors.toList()).toArray(new String[]{});
			if( keywords.length>0){
				return filter(daoFilter,keywords);
			}
		}
		return this;
	}
	/**
	 *  一定要在合适的时候把线程里原来的东西
	 * @param daoFilter
	 * @param keywords
	 * @return
	 */
	public ThreadKeywordLikeFilter filter(String daoFilter,String... keywords) {
		this.begin();//TODO 这个要换一个线程处理器
		AssertUtil.assertSupport(daoFilter!=null, "filter不能为空");
		AssertUtil.assertSupport(this.daoFilters.contains(daoFilter), "filter:[%s]没有被注册",daoFilter);
		AssertUtil.assertSupport(keywords.length>0, "不支持不传参数的filter");
		Map<String, List<String>> map = this.get();
		if(map == null){
			map = new HashMap<String, List<String>>();
			this.set(map);
		}
		
		for (String keyword: keywords) {
			AssertUtil.assertSupport(keyword!=null && keyword.length()>0 , "filter不支持空字符串");
		}
		map.put(daoFilter, Arrays.asList(keywords));
		
		
		logger.debug("线程中KeywordLikeFilters被更新成:{}",map);
		return this;
	}
	
	/**
	 * 这种写法变量不安全，
	 * 应该使用@see {@link #queryKeyword(String)}
	 * @param daoFilter
	 * @return
	 */
	@Deprecated
	public String[] getKeyword(String daoFilter){
		return queryKeyword(daoFilter).orElse(null);
	}
	
	
	public Optional<String[]> queryKeyword(String daoFilter){
		Map<String, List<String>> map = this.get();
		if(map!= null){
			AssertUtil.assertSupport(this.daoFilters.contains(daoFilter), "filter:[%s]没有被注册",daoFilter);
			List<String> keywords = map.get(daoFilter);
			if(keywords!=null){
				logger.info("KeywordLikeFilters从线程中取到filter:[{}]可以使用过滤关键字:{}",daoFilter,keywords);
				return Optional.ofNullable(keywords.toArray(new String[]{}));
			}
		}
		return Optional.empty();
	}
	

	public Set<String> getDaoFilters() {
		return daoFilters;
	}

	public void setDaoFilters(Set<String> daoFilters) {
		this.daoFilters = daoFilters;
	}

}
