package com.mini.framework.util.relation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 我们拒绝自己造轮子。
 * 实在找不到实现方法时我们才考虑造一下轮子。
 * 这里做一下集合特殊处理
 * */
public class CollUtil {
	/**
	 * 例如去除集合中的所有副本,只要集合中A是B的副本，那么 A就会被移除
	 * @param coll 需要处理的集合。
	 * */
	public static  <T> void removeDeputy(Collection<T> coll,Relateder<? super T> relateder){
		removeOnRelation(coll, relateder, Relateder.DEFAULT_DEPUTY_RELATION);
	}
	
	/**
	 * 全量比较集合中的每对两两关系,这个关系会在调用的时候传入，如果A-B得关系等于传入的值，那么A会被移除
	 * eg : @see {@link CollUtil#removeDeputy(Collection, Relateder)}
	 * */
	public static  <T> void removeOnRelation(Collection<T> coll,Relateder<? super T> relateder,int relation){
		boolean change = true;
		while (change && coll.size() > 0){
			change = true;
			Iterator<T> it1 = coll.iterator();
			T toRemove = null;
			boolean conFlag = true;
			while (it1.hasNext()&& conFlag) {
				T element1 = it1.next();
				Iterator<T> it2 = coll.iterator();
				while (it2.hasNext() && conFlag) {
					T element2 = it2.next();
					if(relateder.showRelation(element1,element2)== relation){
						toRemove = element1;
						conFlag = false;
						break;
					}
				}
			}
			change = toRemove != null;
			if(change){
				coll.remove(toRemove);
			}
		}
	}
	
	
	/** 
	* @Title: distinctString 
	* @Description: 把String集合去除重复
	* @param @param coll    设定文件 
	* @return void    返回类型 
	* @author jayheo
	* @throws 
	*/
	public static void distinctString(Collection<String> coll){
		Flagable<String> flagable = new Flagable<String>() {
			
			@Override
			public String showFlag(String t) {
				return t;
			}
		};
		removeAlike(coll, flagable , 1);
	}
	
	
	/** 
	* @Title: removeAlike 
	* @Description: 去掉相似的。顺序找一下去，记录相似的的数据直到达到timeLimit后剩下的就从集合中去除，这里要求集合是有序的。
	* @param @param coll
	* @param @param flagable
	* @param @param timeLimit    允许相似的的次数
	* @return void    返回类型 
	* @author jayheo
	* @throws 
	*/
	public static  <T> void removeAlike(Collection<T> coll,Flagable<? super T> flagable,int timeLimit){
		Map<String, Integer> timeMap = new HashMap<String, Integer>();
		Iterator<T> it = coll.iterator();
		while (it.hasNext()) {
			T t = it.next();
			String flag = flagable.showFlag(t);
			Integer haveTime = timeMap.get(flag);
			if( haveTime == null){
				timeMap.put(flag, 1);
				continue;
			}else if( haveTime < timeLimit){
				timeMap.put(flag, haveTime + 1);
				continue;
			}else{
				it.remove();
			}
		}
	}
	
	/** 
	 * @Title: tranCascadeTree 
	 * @Description: 把集合转变成为级联树
	 * @param @param cascadables   集合
	 * @return void    返回类型 
	 * @author jayheo
	 * @throws 
	 */
	//TODO 流程需要优化，测试了在25000的样本容量下消耗了15秒
	public static <N extends Cascadable<N>,C extends Collection<N>> C tranCascadeTree(C cascadables){
		//生成节点的key和节点的映射
		Map<String, N> nodeKeyMaps = new HashMap<String, N>();
		for (N cascadable : cascadables) {
			nodeKeyMaps.put(cascadable.showNodeKey(), cascadable);
		}
		//得到源数据迭代器
		Iterator<N> cit = cascadables.iterator();
		while (cit.hasNext()) {
			N ca = cit.next();
			String superNodeKey = ca.showSuperNodeKey();
			N superNode = nodeKeyMaps.get(superNodeKey);
			//如果找到父节点，就把自己放进父节点
			if(superNode != null){
				cit.remove();
				superNode.addSonNode(ca);
			}
		}
		return cascadables;
	}
	
/** 
	* @Title: tranCascadeTree 
	* @Description: 把集合转变成为级联树
	* @param @param cascadables   集合
	* @return void    返回类型 
	* @author jayheo
	* @throws 
	*/
	public static <N,C extends Collection<N>> C tranCascadeTree(C targetColl,Cascader<N> cascader){
		//生成节点的key和节点的映射
		Map<String, N> nodeKeyMaps = new HashMap<String, N>();
		for (N cascadable : targetColl) {
			nodeKeyMaps.put(cascader.showNodeKey(cascadable), cascadable);
		}
		//得到源数据迭代器
		Iterator<N> cit = targetColl.iterator();
		while (cit.hasNext()) {
			N ca = cit.next();
			String superNodeKey = cascader.showSuperNodeKey(ca);
			N superNode = nodeKeyMaps.get(superNodeKey);
			//如果找到父节点，就把自己放进父节点
			if(superNode != null){
				cit.remove();
				cascader.addSubNodes(superNode, ca);
			}
		}
		return targetColl;
	}
}
