package com.mini.framework.util.report.statistics.summation.bean;

import com.mini.framework.util.date.DateScopeItems;
import com.mini.framework.util.function.FunctionSpread;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * TODO 待优化代码变量命名
 * 自然时间区间的输出名字
 * @author jayheo
 */
public class NativeRegionTimeOutNames extends LinkedHashMap<String, NativeRegionTimeOutNames.Name> {


    //TODO 根据当前环境设置一个最合理的名字。


    /**
     * 自然时间单元的输出名字。
     */
    public static Function<Date,NativeRegionTimeOutNames> nativeUnitOutName(TimeRegionRange timeRegion,TimeRegionUnit childrenUnit){
        Function<Date, String> function = FunctionSpread.fromMap(scopeChildrenUnitMapper(timeRegion, childrenUnit));
        return date -> {
            String name = function.apply(date);
            Name nameBean = Style.style1.from(name);
            NativeRegionTimeOutNames names = new NativeRegionTimeOutNames();
            names.put(Style.style1.name(),nameBean);
            return names;
        };
    }


    public static Map<Date,String> scopeChildrenUnitMapper(TimeRegionRange timeRegion,TimeRegionUnit childrenUnit){
        List<TimeRegionRange> childrenList = timeRegion.findElementRegionFences(childrenUnit);
        DateScopeItems pair = DateScopeItems.fromScopeItem( timeRegion.getUnit().getSectionUnit(),childrenUnit.getSectionUnit());
        Map<Date, String> mapper = new HashMap<>(childrenList.size());
        childrenList.forEach(children->{
            Date datePoint = children.getOffset();
            String name = pair.countSimpleItemTitle(datePoint);
            mapper.put(datePoint,name);

        });
        return mapper;


    }


    static public class Name{
        //TODO 要说明时间，怎么来的，比如天里的小时。
        private String name;
        private Style style;
        private String desc;

        public Name() {
        }

        public Name(String name, Style style, String desc) {
            this.name = name;
            this.style = style;
            this.desc = desc;
        }

        public Style getStyle() {
            return style;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }


    static public enum Style{


        /**
         * 样式1
         */
        style1("样式1"),


        ;

        private String desc;

        Style(String desc) {
            this.desc = desc;
        }

        public Name from(String name){
            return new Name(name,this,desc);
        }

    }

}
