package com.mini.framework.util.report.statistics.summation.bean.array;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;


/**
 * 自然时间区间序列的统计序列
 */
public class NativeRegionArraySummationArray implements OneStatisticsResult , DivideDenominatorNumeratorSummation<NativeRegionArraySummationArray> {

    private StatisticsResultMeta resultMeta;

    private ForkQueryProcess process;

    private List<NativeRegionSummationElementAmount> elements = new ArrayList<>();

    private List<NativeRegionSummationElementAmount>  elementAccumulates;

    public static NativeRegionArraySummationArray create(List<NativeRegionSummationElementAmount> elements) {
        NativeRegionArraySummationArray instance = new NativeRegionArraySummationArray();
        instance.elements = elements;
        return instance;
    }

    /**
     * 计算累计量，也就是把 n个元素中 1.2...m  0<m<=n 几个元素的值加起来，变成 第 m个值。
     * @return
     */
    public NativeRegionArraySummationArray fillArraySequenceAccumulates(){
        elementAccumulates = new ArrayList<>();
        elements.forEach(element-> {
            NativeRegionSummationElementAmount accumulate = element.copy();
            elementAccumulates.stream()
                    //返回第二个元素，这个写法就得到最后一个元素。
                    .reduce((prev,next)->next)
                    .ifPresent(accumulate::mergeOtherAmount);
            elementAccumulates.add(accumulate);
        });
        return this;
    }

    /**
     * 除以另外一个数
     * @param expand
     * @param numeratorSum
     * @param denominatorSum
     * @param other
     */
    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum, NativeRegionArraySummationArray other){
        AssertUtil.assertNotFatalBug(elements.size()==other.elements.size()
                ,"elements.size():[%s]与other.elements.size():[%s]不一致",elements.size(),other.elements.size());
        this.mergeOtherResultMeta(other);
        for (int elementIndex = 0; elementIndex < elements.size(); elementIndex++) {
            elements.get(elementIndex).mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.elements.get(elementIndex));
        }

        if(elementAccumulates!=null && other.elementAccumulates!=null){
            AssertUtil.assertNotFatalBug(elementAccumulates.size()==other.elementAccumulates.size()
                    ,"elementAccumulates.size():[%s]与other.elementAccumulates.size():[%s]不一致",elementAccumulates.size(),other.elementAccumulates.size());
            for (int elementIndex = 0; elementIndex < elementAccumulates.size(); elementIndex++) {
                elementAccumulates.get(elementIndex).mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.elementAccumulates.get(elementIndex));
            }
        }
    }


    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public List<NativeRegionSummationElementAmount> getElements() {
        return elements;
    }

    public void setElements(List<NativeRegionSummationElementAmount> elements) {
        this.elements = elements;
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public List<NativeRegionSummationElementAmount> getElementAccumulates() {
        return elementAccumulates;
    }

    public void setElementAccumulates(List<NativeRegionSummationElementAmount> elementAccumulates) {
        this.elementAccumulates = elementAccumulates;
    }


    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public void clearRedundancyFields() {
        Stream.of(elements,elementAccumulates).filter(Objects::nonNull).flatMap(List::stream)
                .forEach(OneStatisticsResult::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }
}
