package com.mini.framework.util.require.bean;

import java.util.LinkedHashMap;
import java.util.Map;

import com.mini.framework.util.asserts.AssertUtil;

public class RequireParams {
	
	private LinkedHashMap<String, Object> values = new LinkedHashMap<>();
	
	private RequireParams(){}
	

	public static RequireParams create(Map<String, Object> params) {
		// TODO Auto-generated method stub
		return create().paramsAny(params);
	}

	private RequireParams paramsAny(Map<String, Object> params) {
		values.putAll(params);
		return this;
	}

	public static RequireParams create(String paramKey,Object paramValue){
		return create().paramAny(paramKey, paramValue);
	}
	
	public static RequireParams create(){
		return new RequireParams();
	}
	
	
	/**
	 * 如果是不确定的参数 使用 #paramIfAbsent
	 * @param paramKey
	 * @param paramValue
	 * @return
	 */
	public RequireParams paramAny(String paramKey,Object paramValue){
		//TODO 碰到这个问题 如果是不确定的参数 使用 paramIfAbsent
		AssertUtil.assertMethodRequire(paramValue, "paramValue");
		return paramAnyAllowEmpty(paramKey, paramValue);
	}

	/**
	 * 允许有空
	 * @param paramKey
	 * @param paramValue
	 * @return
	 */
	public RequireParams paramAnyAllowEmpty(String paramKey,Object paramValue){
		AssertUtil.assertMethodRequire(paramKey, "paramKey");
		//TODO 碰到这个问题 如果是不确定的参数 使用 paramIfAbsent
		values.put(paramKey, paramValue);
		return this;
	}
	

	public RequireParams param(String paramKey,ParamFieldPair ParamFieldPair){
		return paramAny(paramKey, ParamFieldPair);
	}
	
	public Object get(String key){
		return values.get(key);
	}
	
	
	public RequireParams(LinkedHashMap<String, Object> values) {
		super();
		this.values = values;
	}


	public String build(){
		return values.toString();
	}
	
	@Override
	public String toString() {
		return build();
	}


	public LinkedHashMap<String, Object> getValues() {
		return values;
	}


	public void setValues(LinkedHashMap<String, Object> values) {
		this.values = values;
	}

	
	
	
}
