package com.mini.framework.util.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import org.apache.commons.io.IOUtils;

import com.mini.framework.core.exception.HandleIOException;

/**
 * 资源工具类
 * @author jayheo
 *
 */
public class ResourceUtil {

	/**
	 * 读文本到list中，使用utf-8
	 * @param classpath
	 * @return
	 */
	public static List<String> readLines(String classpath){
		return readLines(classpath, "utf-8");
	}
	
	/**
	 * 读文本到list中
	 * @param classpath
	 * @param encoding
	 * @return
	 */
	public static List<String> readLines(String classpath, String encoding){
		InputStream input = getInputStream(classpath);
		try {
			return IOUtils.readLines(input, encoding);
		} catch (FileNotFoundException e) {
			throw new HandleIOException(e,"找不到文件:%s",classpath);
		} catch (IOException e) {
			throw new HandleIOException(e,"读文件异常");
		}finally{
			IOUtils.closeQuietly(input);
		}
	}
	
	
	public static InputStream getInputStream(String classpath){
		InputStream res = ResourceUtil.class.getResourceAsStream(classpath);
		return res;
	}
	
}
