package com.mini.framework.util.sql.view.bean;

import java.util.Map;
import java.util.Optional;

/**
 * 在数据库中查到原始数据的列
 * @author jayheo
 */
public class ColumnOrigin extends SqlViewBean {

    /**
     * 名字
     */
    private String key;

    /**
     * 对应的java类型
     */
    private String javaType;


    /**
     * 对应的string型的值
     */
    private String stringValue;


    public static <T> ColumnOrigin from(Map.Entry<String,T> entry){
        return from(entry.getKey(),Optional.ofNullable(entry.getValue()));
    }


    public static ColumnOrigin from(String key, Optional<Object> objectOptional){
        ColumnOrigin instance = new ColumnOrigin();
        instance.key = key;
        objectOptional.ifPresent(instance::fillValueType);
        if(!objectOptional.isPresent()){
            instance.javaType = "Empty";
            instance.stringValue = null;
        }
        return instance;
    }

    /**
     * 填充内容和类型
     * @param object
     * @return
     */
    public ColumnOrigin fillValueType(Object object){
        javaType = object.getClass().getName();
        //TODO 要处理一下日期等类型，根据显示的时取一下。
        stringValue = String.valueOf(object);
        return this;
    }

    public String getKey() {
        return key;
    }

    public ColumnOrigin setKey(String key) {
        this.key = key;
        return this;
    }

    public String getJavaType() {
        return javaType;
    }

    public ColumnOrigin setJavaType(String javaType) {
        this.javaType = javaType;
        return this;
    }

    public String getStringValue() {
        return stringValue;
    }

    public ColumnOrigin setStringValue(String stringValue) {
        this.stringValue = stringValue;
        return this;
    }
}
