package com.mini.framework.util.sql.view.bean;

import com.mini.framework.util.sql.view.able.ObjectValueReader;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author jayheo
 */
public class RowValue extends SqlViewBean {


    /**
     * 行的key，一般是id等唯一性的数据。
     */
    private String key;


    /**
     * 每一个的每个内容
     */
    private List<ColumnValue> items;


    public static RowValue fromReader(ObjectValueReader reader, List<ColumnDefine> defines){
        RowValue instance = new RowValue();
        instance.items = defines.stream().map(define -> ColumnValue.fromReader(reader,define)).collect(Collectors.toList());
        //TODO key 还待梳理
        return instance;
    }



    public String getKey() {
        return key;
    }

    public RowValue setKey(String key) {
        this.key = key;
        return this;
    }

    public List<ColumnValue> getItems() {
        return items;
    }

    public RowValue setItems(List<ColumnValue> items) {
        this.items = items;
        return this;
    }
}
