package com.mini.framework.util.store;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.store.bean.Copyable;
import com.mini.framework.util.store.bean.StringKeyable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 内存 存储器
 */
public class MemoryTableStorage<E extends StringKeyable<E>> {

    private List<E> storage = new ArrayList<>();


    /**
     * 以覆盖的形式保存
     * @param element
     */
    public E coverSave(E element){
        AssertUtil.assertNotFatalProgramConfig(element.showKey()!=null, Status.Server.programConfigJava,"元素的key不能为空");
        removeByKey(element);
        storage.add(element.copy());
        return queryOnlyOneByKey(element)
                .orElseThrow(()->new ServerException("存储失败了 元素:%s",element));
    }

    public <F> boolean matchFilter(E element, F filter, Function<E,F> filterGetter){
        return filter.equals(filterGetter.apply(element));
    }

    public <F> List<E> queryByFilter(F filter,Function<E,F> filterGetter){
        return storage.stream()
                .filter(element -> matchFilter(element,filter,filterGetter))
                .map(Copyable::copy)
                .collect(Collectors.toList());
    }



    public <K> Optional<E> queryOnlyOneByKey(E element){
        AssertUtil.assertNotFatalProgramConfig(element.showKey()!=null, Status.Server.programConfigJava,"元素的key不能为空");
        return queryOnlyOneByKey(element.showKey());
    }


    /**
     * 通过key删除值
     * @param element
     * @return
     */
    public int removeByKey(E element){
        AssertUtil.assertNotFatalProgramConfig(element.showKey()!=null, Status.Server.programConfigJava,"元素的key不能为空");
        return removeByKey(element.showKey());
    }

    /**
     * 通过key删除值
     * @param key
     * @return
     */
    public int removeByKey(String key){
        AssertUtil.assertMethodRequire(key,"key");
        Iterator<E> it = storage.iterator();
        int count = 0;
        while (it.hasNext()){
            E element = it.next();
            if(element.matchKey(key)){
                it.remove();
                count++;
            }
        }
        return count;
    }

    
    public <K> Optional<E> queryOnlyOneByKey(String key){
        AssertUtil.assertMethodRequire(key,"key");
        List<E> results = queryByFilter(key, StringKeyable::showKey);
        //TODO 提供非空限制
        return results.stream().findFirst();
    }

}
