package com.mini.framework.util.test;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassRelativeResourceLoader;
import org.springframework.core.io.Resource;

import com.mini.framework.core.exception.HandleIOException;


/**
 * 测试时读取文件的支持。
 * 注意检查项目目录中有没有文件夹 'target\test-classes\' 里面有没有对应的文件。
 */
public interface TestFileSupport {

	static String namespaceToPath(String namespace){
		return namespace.replace(".", "/"); 
	}
	
	/**
	 * 读取当前目录下某个文件的内容
	 * @param fileName
	 * @return
	 */
	default public List<String> readThisDirFileLines(String fileName){
		return readFileLines(getThisDirFile(fileName));
	}

	default public String readThisDirFileContent(String fileName){
		return readThisDirFileContent( fileName,"\n");
	}
	
	
	default public String readThisDirFileContent(String fileName,String lineSplit){
		return readThisDirFileLines(fileName).stream().collect(Collectors.joining(lineSplit));
	}
		
		

	default public List<List<String>> getThisDirFilesContent(Predicate<File> predicate){
		return Stream.of(getThisDirFile().listFiles()).filter(File::isFile).filter(predicate)
		 .map(TestFileSupport::readFileLines)
		 .collect(Collectors.toList());
	}
	
	static public List<String> readFileLines(File file){
		try {
			return IOUtils.readLines(new FileReader(file));
		} catch (IOException e) {
			throw new HandleIOException(e, "文件内容:[%s]失败", file);
		}
	} 
	
	
	default public List<File> getThisDirFiles(Predicate<File> predicate){
		return Stream.of(getThisDirFile().listFiles()).filter(predicate).collect(Collectors.toList());
	}
	
	
	default public List<String> readClasspathFileLines(String classPath, String fileName){
		return readFileLines(getClasspathFile(classPath, fileName));
	}
	
	
	default public File getClasspathFile(String classPath,String fileName){
		Resource fileRes  = new ClassRelativeResourceLoader(TestResourseUtil.class).getResource("classpath:/" +namespaceToPath(classPath) + "/" +fileName);
		try {
			return fileRes.getFile();
		} catch (IOException e) {
			throw new HandleIOException(e, "读取当classPath:[%s]文件失败",classPath);
		}
		
	}
	
	
	default public File getThisDirFile(){
		Package pack = this.getClass().getPackage();
		String dirPath = "classpath:/" +namespaceToPath( pack.getName()) ;
		final Resource dir = new ClassRelativeResourceLoader(TestResourseUtil.class).getResource(dirPath);
		try {
			return dir.getFile();
		} catch (IOException e) {
			throw new HandleIOException(e, "读取当前类%s的同目录失败",this.getClass(), dir);
		}
	}
	
	static Predicate<File> getSuffixPredicate(String suffix){
		return file->file.getName().endsWith(suffix);
	}
	
	default Function<List<String>,String> listStringToString(String split){
		return list->String.join(split, list);
	}
	
	
	default public File getThisDirFile(String fileName){
		return new File( getThisDirFile(),fileName);
	}
}
