package com.mini.framework.util.thread;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.log.trace.LinkTraceFace;

public class SimpleSiteThreadBinder<T, O> implements HaveCurrSiteable<T> {

	private T currSiteId;
	
	private String traceId;

	public O tranObj;
	
	public SimpleSiteThreadBinder(T currSiteId) {
		super();
		traceId = LinkTraceFace.showTraceId();
		this.currSiteId = currSiteId;
	}

	public SimpleSiteThreadBinder(T currSiteId, O tranObj) {
		super();
		traceId = LinkTraceFace.showTraceId();
		this.currSiteId = currSiteId;
		this.tranObj = tranObj;
	}

	public void setCurrSiteId(T currSiteId) {
		this.currSiteId = currSiteId;
	}

	public O getTranObj() {
		return tranObj;
	}

	public void setTranObj(O tranObj) {
		this.tranObj = tranObj;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	@Override
	public T getCurrSiteId() {
		return currSiteId;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
