package com.mini.framework.util.type;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 枚举的
 * @author jayheo
 *
 * @param <E>
 */
public interface EnumTypeShower<E extends  EnumTypeShower<E>> extends EnumSupport<E>{

	
	/**
	 * 填充map，name就不要填了。
	 * @param map
	 */
	public void fillFieldToMap(Map<String, Object> map);
	
	default public Map<String, Object> showFieldMap(){
		LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
		fillFieldToMap(map);
		map.put("name",showName());
		return map;
	}
	
	default public List<Map<String, Object>> showFieldMaps(){
		return showValues().stream().map(EnumTypeShower::showFieldMap).collect(Collectors.toList());
	}
}
