/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import java.util.regex.Pattern;

public class CharacterUtil {
    public static Pattern reSkip = Pattern.compile("(\\d+\\.\\d+|[a-zA-Z0-9]+)");
    private static final char[] connectors = new char[]{'+', '#', '&', '.', '_', '-'};

    public static boolean isChineseLetter(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static boolean isEnglishLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isConnector(char ch) {
        for (char connector : connectors) {
            if (ch != connector) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseOrEnglishLetter(char ch) {
        return CharacterUtil.isChineseLetter(ch) || CharacterUtil.isEnglishLetter(ch);
    }

    public static char regularize(char input) {
        if (input == '\u3000') {
            return ' ';
        }
        if (input >= '\uff01' && input <= '\uff5e') {
            return (char)(input - 65248);
        }
        if (input >= 'A' && input <= 'Z') {
            return (char)(input + 32);
        }
        return input;
    }
}

