/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FinalSegmenter {
    private static volatile FinalSegmenter instance;
    private static final String PROB_EMIT = "/prob_emit.txt";
    private static final char[] STATES;
    private static final double MIN_FLOAT = -3.14E100;
    private final Map<Character, Map<Character, Double>> emitProb = new HashMap<Character, Map<Character, Double>>();
    private final Map<Character, Double> startProb = new HashMap<Character, Double>();
    private final Map<Character, Map<Character, Double>> transProb = new HashMap<Character, Map<Character, Double>>();
    private final Map<Character, char[]> prevStatus = new HashMap<Character, char[]>();

    private FinalSegmenter() {
        this.loadModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FinalSegmenter getInstance() {
        if (instance != null) return instance;
        Class<FinalSegmenter> clazz = FinalSegmenter.class;
        synchronized (FinalSegmenter.class) {
            if (instance != null) return instance;
            instance = new FinalSegmenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadModel() {
        this.prevStatus.put(Character.valueOf('B'), new char[]{'E', 'S'});
        this.prevStatus.put(Character.valueOf('M'), new char[]{'M', 'B'});
        this.prevStatus.put(Character.valueOf('E'), new char[]{'B', 'M'});
        this.prevStatus.put(Character.valueOf('S'), new char[]{'S', 'E'});
        this.startProb.put(Character.valueOf('B'), -0.26268660809250016);
        this.startProb.put(Character.valueOf('E'), -3.14E100);
        this.startProb.put(Character.valueOf('M'), -3.14E100);
        this.startProb.put(Character.valueOf('S'), -1.4652633398537678);
        HashMap<Character, Double> emitProbB = new HashMap<Character, Double>();
        emitProbB.put(Character.valueOf('E'), -0.51082562376599);
        emitProbB.put(Character.valueOf('M'), -0.916290731874155);
        this.transProb.put(Character.valueOf('B'), emitProbB);
        HashMap<Character, Double> emitProbM = new HashMap<Character, Double>();
        emitProbM.put(Character.valueOf('E'), -0.33344856811948514);
        emitProbM.put(Character.valueOf('M'), -1.2603623820268226);
        this.transProb.put(Character.valueOf('M'), emitProbM);
        HashMap<Character, Double> emitProbE = new HashMap<Character, Double>();
        emitProbE.put(Character.valueOf('B'), -0.5897149736854513);
        emitProbE.put(Character.valueOf('S'), -0.8085250474669937);
        this.transProb.put(Character.valueOf('E'), emitProbE);
        HashMap<Character, Double> emitProbS = new HashMap<Character, Double>();
        emitProbS.put(Character.valueOf('B'), -0.7211965654669841);
        emitProbS.put(Character.valueOf('S'), -0.6658631448798212);
        this.transProb.put(Character.valueOf('S'), emitProbS);
        InputStream is = this.getClass().getResourceAsStream(PROB_EMIT);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            HashMap<Character, Double> currentMap = null;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split("\t");
                if (tokens.length == 1) {
                    currentMap = new HashMap<Character, Double>();
                    this.emitProb.put(Character.valueOf(tokens[0].charAt(0)), currentMap);
                    continue;
                }
                currentMap.put(Character.valueOf(tokens[0].charAt(0)), Double.parseDouble(tokens[1]));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load emission probabilities: /prob_emit.txt");
        }
    }

    public List<String> cut(String sentence) {
        int i;
        ArrayList<String> tokens = new ArrayList<String>();
        if (sentence == null || sentence.isEmpty()) {
            return tokens;
        }
        int length = sentence.length();
        double[][] dp = new double[length][STATES.length];
        int[][] path = new int[length][STATES.length];
        for (i = 0; i < STATES.length; ++i) {
            char state = STATES[i];
            double emit = this.emitProb.getOrDefault(Character.valueOf(state), Collections.emptyMap()).getOrDefault(Character.valueOf(sentence.charAt(0)), -3.14E100);
            dp[0][i] = this.startProb.getOrDefault(Character.valueOf(state), -3.14E100) + emit;
        }
        for (i = 1; i < length; ++i) {
            for (int j = 0; j < STATES.length; ++j) {
                char current = STATES[j];
                dp[i][j] = Double.NEGATIVE_INFINITY;
                for (int k = 0; k < STATES.length; ++k) {
                    double emit;
                    char prev = STATES[k];
                    double trans = this.transProb.getOrDefault(Character.valueOf(prev), Collections.emptyMap()).getOrDefault(Character.valueOf(current), -3.14E100);
                    double score = dp[i - 1][k] + trans + (emit = this.emitProb.getOrDefault(Character.valueOf(current), Collections.emptyMap()).getOrDefault(Character.valueOf(sentence.charAt(i)), -3.14E100).doubleValue());
                    if (!(score > dp[i][j])) continue;
                    dp[i][j] = score;
                    path[i][j] = k;
                }
            }
        }
        int lastState = 0;
        for (int i2 = 1; i2 < STATES.length; ++i2) {
            if (!(dp[length - 1][i2] > dp[length - 1][lastState])) continue;
            lastState = i2;
        }
        ArrayList<Character> bestPath = new ArrayList<Character>();
        for (int i3 = length - 1; i3 >= 0; --i3) {
            bestPath.add(Character.valueOf(STATES[lastState]));
            lastState = path[i3][lastState];
        }
        Collections.reverse(bestPath);
        StringBuilder token = new StringBuilder();
        for (int i4 = 0; i4 < length; ++i4) {
            char state = ((Character)bestPath.get(i4)).charValue();
            token.append(sentence.charAt(i4));
            if (state != 'E' && state != 'S') continue;
            tokens.add(token.toString());
            token.setLength(0);
        }
        return tokens;
    }

    static {
        STATES = new char[]{'B', 'M', 'E', 'S'};
    }
}

