/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import java.util.Objects;

public class ScoredEntity<T>
implements Comparable<ScoredEntity<T>> {
    private final T item;
    private final double score;

    public ScoredEntity(T item, double weight) {
        this.item = item;
        this.score = (double)Math.round(weight * 10000.0) / 10000.0;
    }

    public T getItem() {
        return this.item;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public int compareTo(ScoredEntity<T> other) {
        return Double.compare(other.score, this.score);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.score);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoredEntity that = (ScoredEntity)obj;
        return Double.compare(that.score, this.score) == 0 && Objects.equals(this.item, that.item);
    }

    public String toString() {
        return "ScoredEntity{item=" + this.item + ", score=" + this.score + '}';
    }
}

