/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import io.github.javpower.vectorex.keynote.analysis.Hit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TrieSegment
implements Comparable<TrieSegment> {
    private static final Map<Character, Character> charMap = new HashMap<Character, Character>();
    private static final int ARRAY_SIZE_LIMIT = 3;
    private final Character nodeChar;
    private Map<Character, TrieSegment> childrenMap;
    private TrieSegment[] childrenArray;
    private int storeSize = 0;
    private int nodeState = 0;

    public TrieSegment(Character nodeChar) {
        if (nodeChar == null) {
            throw new IllegalArgumentException("Node character cannot be null");
        }
        this.nodeChar = nodeChar;
    }

    public Character getNodeChar() {
        return this.nodeChar;
    }

    public boolean hasNextNode() {
        return this.storeSize > 0;
    }

    public Hit match(char[] charArray, int begin, int length, Hit searchHit) {
        if (searchHit == null) {
            searchHit = new Hit();
            searchHit.setBegin(begin);
        } else {
            searchHit.setUnmatch();
        }
        searchHit.setEnd(begin);
        Character keyChar = Character.valueOf(charArray[begin]);
        TrieSegment segment = this.findSegment(keyChar);
        if (segment != null) {
            if (length > 1) {
                return segment.match(charArray, begin + 1, length - 1, searchHit);
            }
            if (length == 1) {
                if (segment.nodeState == 1) {
                    searchHit.setMatch();
                }
                if (segment.hasNextNode()) {
                    searchHit.setPrefix();
                    searchHit.setMatchedSegment(segment);
                }
            }
        }
        return searchHit;
    }

    private TrieSegment findSegment(Character keyChar) {
        if (this.childrenArray != null) {
            TrieSegment keySegment = new TrieSegment(keyChar);
            int position = Arrays.binarySearch(this.childrenArray, 0, this.storeSize, keySegment);
            if (position >= 0) {
                return this.childrenArray[position];
            }
        } else if (this.childrenMap != null) {
            return this.childrenMap.get(keyChar);
        }
        return null;
    }

    public void fillSegment(char[] charArray, int begin, int length, int state) {
        Character keyChar = Character.valueOf(charArray[begin]);
        Character mappedChar = charMap.computeIfAbsent(keyChar, k -> keyChar);
        TrieSegment segment = this.findSegment(mappedChar);
        if (segment == null) {
            segment = new TrieSegment(mappedChar);
            this.addSegment(segment);
        }
        if (length > 1) {
            segment.fillSegment(charArray, begin + 1, length - 1, state);
        } else {
            segment.nodeState = state;
        }
    }

    private void addSegment(TrieSegment segment) {
        if (this.storeSize <= 3) {
            if (this.childrenArray == null) {
                this.childrenArray = new TrieSegment[3];
            }
            if (this.storeSize == 3) {
                this.migrateToMap();
            } else {
                this.childrenArray[this.storeSize++] = segment;
                Arrays.sort(this.childrenArray, 0, this.storeSize);
            }
        } else {
            if (this.childrenMap == null) {
                this.childrenMap = new HashMap<Character, TrieSegment>();
                this.migrateToMap();
            }
            this.childrenMap.put(segment.getNodeChar(), segment);
        }
    }

    private void migrateToMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<Character, TrieSegment>();
        }
        if (this.childrenArray != null) {
            for (int i = 0; i < this.storeSize; ++i) {
                if (this.childrenArray[i] == null) continue;
                this.childrenMap.put(this.childrenArray[i].getNodeChar(), this.childrenArray[i]);
            }
            this.childrenArray = null;
        }
    }

    @Override
    public int compareTo(TrieSegment o) {
        return this.nodeChar.compareTo(o.nodeChar);
    }
}

