/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.core;

import io.github.javpower.vectorex.keynote.graph.core.AdjacencyCache;
import io.github.javpower.vectorex.keynote.graph.entity.EdgeInfo;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import io.github.javpower.vectorex.keynote.graph.entity.Relationship;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class GraphDB {
    private final DB db;
    private final HTreeMap<String, Node> nodes;
    private final HTreeMap<String, Relationship> relationships;
    private final HTreeMap<String, Set<String>> labelIndex;
    private final HTreeMap<String, Set<String>> relTypeIndex;
    private final HTreeMap<String, Map<Object, Set<String>>> nodePropertyIndex;
    private final HTreeMap<String, List<Relationship>> inEdges;
    private final AdjacencyCache adjacencyCache;

    public GraphDB(String dbPath) {
        this.db = DBMaker.fileDB((String)dbPath).closeOnJvmShutdown().make();
        this.nodes = this.db.hashMap("nodes", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.relationships = this.db.hashMap("relationships", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.labelIndex = this.db.hashMap("labelIndex", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.relTypeIndex = this.db.hashMap("relTypeIndex", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.nodePropertyIndex = this.db.hashMap("nodePropertyIndex", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.inEdges = this.db.hashMap("inEdges", (Serializer)Serializer.STRING, (Serializer)Serializer.JAVA).createOrOpen();
        this.adjacencyCache = new AdjacencyCache(this);
    }

    public void addNode(Node node) {
        this.nodes.put((Object)node.getId(), (Object)node);
        this.updateLabelIndex(node);
        this.updatePropertyIndex(node);
        this.adjacencyCache.updateCacheForNode(node.getId());
    }

    public void addRelationship(Relationship rel) {
        if (!this.nodes.containsKey((Object)rel.getStartNodeId()) || !this.nodes.containsKey((Object)rel.getEndNodeId())) {
            throw new IllegalArgumentException("Start or end node does not exist");
        }
        this.relationships.put((Object)rel.getId(), (Object)rel);
        Node startNode = (Node)this.nodes.get((Object)rel.getStartNodeId());
        startNode.getOutgoingEdgesInternal().add(rel);
        this.nodes.put((Object)rel.getStartNodeId(), (Object)startNode);
        ((List)this.inEdges.computeIfAbsent((Object)rel.getEndNodeId(), k -> new CopyOnWriteArrayList())).add(rel);
        ((Set)this.relTypeIndex.computeIfAbsent((Object)rel.getType(), k -> ConcurrentHashMap.newKeySet())).add(rel.getId());
        this.adjacencyCache.updateCacheForNode(rel.getStartNodeId());
        this.adjacencyCache.updateCacheForNode(rel.getEndNodeId());
    }

    public List<Relationship> getInEdges(String nodeId) {
        return (List)this.inEdges.getOrDefault((Object)nodeId, Collections.emptyList());
    }

    public List<Node> findNodesByProperty(String key, Object value) {
        return this.nodes.values().stream().filter(node -> value.equals(node.getProperty(key))).collect(Collectors.toList());
    }

    public List<Node> findNodesByLabel(String label) {
        return ((Set)this.labelIndex.getOrDefault((Object)label, Collections.emptySet())).stream().map(arg_0 -> this.nodes.get(arg_0)).collect(Collectors.toList());
    }

    public List<Relationship> findRelationshipsByType(String type) {
        return ((Set)this.relTypeIndex.getOrDefault((Object)type, Collections.emptySet())).stream().map(arg_0 -> this.relationships.get(arg_0)).collect(Collectors.toList());
    }

    public List<Node> findNeighbors(String nodeId) {
        Node node = (Node)this.nodes.get((Object)nodeId);
        if (node == null) {
            return Collections.emptyList();
        }
        return node.getOutgoingEdges().stream().map(rel -> (Node)this.nodes.get((Object)rel.getEndNodeId())).collect(Collectors.toList());
    }

    public List<String> shortestPathWithWeights(String startId, String endId) {
        if (startId.equals(endId)) {
            return Collections.singletonList(startId);
        }
        if (!this.containsNode(startId) || !this.containsNode(endId)) {
            return Collections.emptyList();
        }
        PriorityQueue<NodeDistance> queue = new PriorityQueue<NodeDistance>(Comparator.comparingDouble(n -> n.distance));
        ConcurrentHashMap<String, Double> distances = new ConcurrentHashMap<String, Double>();
        ConcurrentHashMap<String, String> predecessors = new ConcurrentHashMap<String, String>();
        this.getAllNodeIds().forEach(id -> distances.put((String)id, (Double)Double.MAX_VALUE));
        distances.put(startId, 0.0);
        queue.add(new NodeDistance(startId, 0.0));
        while (!queue.isEmpty()) {
            NodeDistance current = queue.poll();
            if (current.nodeId.equals(endId)) break;
            for (EdgeInfo edge : this.adjacencyCache.getOutEdges(current.nodeId)) {
                double newDist = current.distance + edge.getWeight();
                if (!(newDist < (Double)distances.get(edge.getTargetId()))) continue;
                distances.put(edge.getTargetId(), newDist);
                predecessors.put(edge.getTargetId(), current.nodeId);
                queue.add(new NodeDistance(edge.getTargetId(), newDist));
            }
        }
        return this.buildPath(predecessors, endId);
    }

    private List<String> buildPath(Map<String, String> predecessors, String endId) {
        if (!predecessors.containsKey(endId) && !endId.equals(predecessors.get(endId))) {
            return Collections.emptyList();
        }
        LinkedList<String> path = new LinkedList<String>();
        String current = endId;
        while (current != null) {
            path.addFirst(current);
            current = predecessors.get(current);
        }
        return path;
    }

    public void updateAdjacencyCache(String nodeId) {
        this.adjacencyCache.updateCacheForNode(nodeId);
        this.getInEdges(nodeId).forEach(rel -> this.adjacencyCache.updateCacheForNode(rel.getStartNodeId()));
    }

    public boolean containsNode(String id) {
        return this.nodes.containsKey((Object)id);
    }

    public Node getNode(String id) {
        return (Node)this.nodes.get((Object)id);
    }

    public Set<String> getAllNodeIds() {
        return this.nodes.keySet();
    }

    private void updateLabelIndex(Node node) {
        node.getLabels().forEach(label -> ((Set)this.labelIndex.computeIfAbsent(label, k -> ConcurrentHashMap.newKeySet())).add(node.getId()));
    }

    private void updatePropertyIndex(Node node) {
        node.getProperties().forEach((key, value) -> ((Map)this.nodePropertyIndex.computeIfAbsent(key, k -> new ConcurrentHashMap())).computeIfAbsent(value, k -> ConcurrentHashMap.newKeySet()).add(node.getId()));
    }

    public Node removeNode(String nodeId) {
        Node node = (Node)this.nodes.remove((Object)nodeId);
        if (node != null) {
            new ArrayList<Relationship>(node.getOutgoingEdges()).forEach(rel -> this.removeRelationship(rel.getId()));
            List inRels = (List)this.inEdges.remove((Object)nodeId);
            if (inRels != null) {
                inRels.forEach(rel -> {
                    Relationship cfr_ignored_0 = (Relationship)this.relationships.remove((Object)rel.getId());
                });
            }
            this.removeFromLabelIndex(node);
            this.removeFromPropertyIndex(node);
        }
        return node;
    }

    private void removeFromLabelIndex(Node node) {
        node.getLabels().forEach(label -> {
            Set ids = (Set)this.labelIndex.get(label);
            if (ids != null) {
                ids.remove(node.getId());
            }
        });
    }

    private void removeFromPropertyIndex(Node node) {
        node.getProperties().forEach((key, value) -> {
            Set ids;
            Map valueMap = (Map)this.nodePropertyIndex.get(key);
            if (valueMap != null && (ids = (Set)valueMap.get(value)) != null) {
                ids.remove(node.getId());
            }
        });
    }

    public Relationship removeRelationship(String relId) {
        Relationship rel = (Relationship)this.relationships.remove((Object)relId);
        if (rel != null) {
            Set rels;
            List inRelList;
            Node startNode = (Node)this.nodes.get((Object)rel.getStartNodeId());
            if (startNode != null) {
                startNode.getOutgoingEdgesInternal().removeIf(e -> e.getId().equals(relId));
                this.nodes.put((Object)rel.getStartNodeId(), (Object)startNode);
            }
            if ((inRelList = (List)this.inEdges.get((Object)rel.getEndNodeId())) != null) {
                inRelList.removeIf(r -> r.getId().equals(relId));
            }
            if ((rels = (Set)this.relTypeIndex.get((Object)rel.getType())) != null) {
                rels.remove(relId);
            }
        }
        return rel;
    }

    private static class NodeDistance
    implements Comparable<NodeDistance>,
    Serializable {
        final String nodeId;
        final double distance;

        NodeDistance(String nodeId, double distance) {
            this.nodeId = nodeId;
            this.distance = distance;
        }

        @Override
        public int compareTo(NodeDistance o) {
            return Double.compare(this.distance, o.distance);
        }
    }
}

