/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.index.bm25;

import io.github.javpower.vectorex.keynote.bm25.BM25;
import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Bm25IndexManager {
    private final BM25 bm25 = new BM25(1.2, 0.75);
    private final Map<String, Map<String, String>> bm25Index = new ConcurrentHashMap<String, Map<String, String>>();

    public void index(DbData data) {
        String id = data.getId();
        Map<String, Object> metadata = data.getMetadata();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            String text = (String)value;
            Map fieldIndex = this.bm25Index.computeIfAbsent(field, k -> new ConcurrentHashMap());
            fieldIndex.put(id, text);
        }
    }

    public void remove(String id) {
        for (Map<String, String> fieldIndex : this.bm25Index.values()) {
            fieldIndex.remove(id);
        }
    }

    public void update(DbData data) {
        this.remove(data.getId());
        this.index(data);
    }

    public List<VectorSearchResult> search(String annsField, String queryVector, int k) {
        return this.search(annsField, queryVector, k, null);
    }

    public List<VectorSearchResult> search(String annsField, String queryVector, int k, Set<String> includedIds) {
        Map<String, String> fieldIndex = this.bm25Index.get(annsField);
        if (fieldIndex == null || fieldIndex.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> filteredCorpora = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldIndex.entrySet()) {
            String id = entry.getKey();
            String text = entry.getValue();
            if (includedIds != null && !includedIds.contains(id)) continue;
            filteredCorpora.put(id, text);
        }
        Map<String, Double> rankBM25 = this.bm25.rankBM25(queryVector, filteredCorpora, k);
        ArrayList<VectorSearchResult> results = new ArrayList<VectorSearchResult>();
        for (Map.Entry<String, Double> entry : rankBM25.entrySet()) {
            VectorSearchResult vectorSearchResult = new VectorSearchResult();
            vectorSearchResult.setId(entry.getKey());
            vectorSearchResult.setScore(Float.valueOf(entry.getValue().floatValue()));
            results.add(vectorSearchResult);
        }
        return results;
    }
}

