/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.index.scalar;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.index.scalar.RangeCondition;
import io.github.javpower.vectorex.keynote.query.ConditionBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ScalarIndexManager {
    private final Map<String, DbData> metadataIndex = new ConcurrentHashMap<String, DbData>();
    private final Map<String, Map<Object, Set<String>>> invertedIndexMap = new ConcurrentHashMap<String, Map<Object, Set<String>>>();
    private final Map<String, TreeMap<Comparable<?>, Set<String>>> rangeIndexMap = new ConcurrentHashMap();

    public void index(DbData data) {
        String id = data.getId();
        Map<String, Object> metadata = data.getMetadata();
        this.metadataIndex.put(id, data);
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof List)) {
                this.updateInvertedIndex(field, value, id);
            }
            if (!(value instanceof Comparable)) continue;
            this.updateRangeIndex(field, (Comparable)value, id);
        }
    }

    public void remove(String id) {
        DbData metadata = this.metadataIndex.remove(id);
        if (metadata == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : metadata.getMetadata().entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof List)) {
                this.removeFromInvertedIndex(field, value, id);
            }
            if (!(value instanceof Comparable)) continue;
            this.removeFromRangeIndex(field, (Comparable)value, id);
        }
    }

    public List<String> search(ConditionBuilder conditionBuilder) {
        Predicate<Map<String, Object>> predicate = conditionBuilder.build();
        Set<String> resultSet = null;
        for (Map.Entry<String, Object> entry2 : conditionBuilder.getIndexConditions().entrySet()) {
            Object value;
            String field = entry2.getKey();
            Set<String> ids = this.queryInvertedIndex(field, value = entry2.getValue());
            if (ids.isEmpty()) {
                return Collections.emptyList();
            }
            resultSet = resultSet == null ? new HashSet<String>(ids) : this.intersect(resultSet, ids);
        }
        for (RangeCondition rangeCondition : conditionBuilder.getRangeConditions()) {
            Set<String> ids = this.queryRangeIndex(rangeCondition);
            if (ids.isEmpty()) {
                return Collections.emptyList();
            }
            resultSet = resultSet == null ? new HashSet<String>(ids) : this.intersect(resultSet, ids);
        }
        if (resultSet == null) {
            return this.metadataIndex.entrySet().stream().filter(entry -> predicate.test(((DbData)entry.getValue()).getMetadata())).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return resultSet.stream().filter(id -> {
            DbData metadata = this.metadataIndex.get(id);
            return metadata != null && predicate.test(metadata.getMetadata());
        }).collect(Collectors.toList());
    }

    private void updateRangeIndex(String field, Comparable<?> value, String id) {
        TreeMap rangeIndex = this.rangeIndexMap.computeIfAbsent(field, k -> new TreeMap());
        Set ids = rangeIndex.computeIfAbsent(value, k -> new HashSet());
        ids.add(id);
    }

    private void removeFromRangeIndex(String field, Comparable<?> value, String id) {
        Set<String> ids;
        TreeMap<Comparable<?>, Set<String>> rangeIndex = this.rangeIndexMap.get(field);
        if (rangeIndex != null && (ids = rangeIndex.get(value)) != null) {
            ids.remove(id);
            if (ids.isEmpty()) {
                rangeIndex.remove(value);
            }
        }
    }

    private Set<String> queryRangeIndex(RangeCondition rangeCondition) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, TreeMap<Comparable<?>, Set<String>>> entry : this.rangeIndexMap.entrySet()) {
            TreeMap<Comparable<?>, Set<String>> rangeIndex = entry.getValue();
            NavigableMap<Comparable<?>, Set<String>> subMap = rangeIndex.subMap(rangeCondition.getFromKey(), rangeCondition.isIncludeFrom(), rangeCondition.getToKey(), rangeCondition.isIncludeTo());
            for (Set ids : subMap.values()) {
                result.addAll(ids);
            }
        }
        return result;
    }

    private void updateInvertedIndex(String field, Object value, String id) {
        Map invertedIndex = this.invertedIndexMap.computeIfAbsent(field, k -> new HashMap());
        Set ids = invertedIndex.computeIfAbsent(value, k -> new HashSet());
        ids.add(id);
    }

    private void removeFromInvertedIndex(String field, Object value, String id) {
        Set<String> ids;
        Map<Object, Set<String>> invertedIndex = this.invertedIndexMap.get(field);
        if (invertedIndex != null && (ids = invertedIndex.get(value)) != null) {
            ids.remove(id);
            if (ids.isEmpty()) {
                invertedIndex.remove(value);
            }
        }
    }

    private Set<String> queryInvertedIndex(String field, Object value) {
        Map<Object, Set<String>> invertedIndex = this.invertedIndexMap.get(field);
        if (invertedIndex == null) {
            return new HashSet<String>();
        }
        return invertedIndex.get(value);
    }

    private Set<String> intersect(Set<String> set1, Set<String> set2) {
        HashSet<String> result = new HashSet<String>(set1);
        result.retainAll(set2);
        return result;
    }

    public DbData getDbDataById(String id) {
        return this.metadataIndex.get(id);
    }
}

