/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.index.vector;

import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.index.vector.HNSWIndex;
import io.github.javpower.vectorex.keynote.model.MetricType;
import java.util.List;
import java.util.Set;

public class VectorIndexManager {
    private HNSWIndex hnswIndex;

    public VectorIndexManager(int dimensions, int maxDateCount, MetricType type) {
        this.hnswIndex = new HNSWIndex(dimensions, maxDateCount, type);
    }

    public void index(VectorData data) {
        this.hnswIndex.add(data);
    }

    public void remove(String id) {
        this.hnswIndex.remove(id);
    }

    public void update(VectorData data) {
        this.remove(data.id());
        this.index(data);
    }

    public List<VectorSearchResult> search(List<Float> queryVector, int k) {
        return this.hnswIndex.search(queryVector, k);
    }

    public List<VectorSearchResult> search(List<Float> queryVector, int k, Set<String> includedIds) {
        return this.hnswIndex.search(queryVector, k, includedIds);
    }
}

