/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn.hnsw;

import io.github.javpower.vectorex.keynote.knn.DistanceFunction;
import io.github.javpower.vectorex.keynote.knn.Index;
import io.github.javpower.vectorex.keynote.knn.Item;
import io.github.javpower.vectorex.keynote.knn.JavaObjectSerializer;
import io.github.javpower.vectorex.keynote.knn.ObjectSerializer;
import io.github.javpower.vectorex.keynote.knn.ProgressListener;
import io.github.javpower.vectorex.keynote.knn.SearchResult;
import io.github.javpower.vectorex.keynote.knn.hnsw.SizeLimitExceededException;
import io.github.javpower.vectorex.keynote.knn.util.ArrayBitSet;
import io.github.javpower.vectorex.keynote.knn.util.ClassLoaderObjectInputStream;
import io.github.javpower.vectorex.keynote.knn.util.DummyComparator;
import io.github.javpower.vectorex.keynote.knn.util.GenericObjectPool;
import io.github.javpower.vectorex.keynote.knn.util.Murmur3;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;

public class HnswIndex<TId, TVector, TItem extends Item<TId, TVector>, TDistance>
implements Index<TId, TVector, TItem, TDistance> {
    private static final byte VERSION_1 = 1;
    private static final byte VERSION_2 = 2;
    private static final long serialVersionUID = 1L;
    private static final int NO_NODE_ID = -1;
    private DistanceFunction<TVector, TDistance> distanceFunction;
    private Comparator<TDistance> distanceComparator;
    private MaxValueComparator<TDistance> maxValueDistanceComparator;
    private boolean immutable;
    private int dimensions;
    private int maxItemCount;
    private int m;
    private int maxM;
    private int maxM0;
    private double levelLambda;
    private int ef;
    private int efConstruction;
    private boolean removeEnabled;
    private int nodeCount;
    private volatile Node<TItem> entryPoint;
    private AtomicReferenceArray<Node<TItem>> nodes;
    private MutableObjectIntMap<TId> lookup;
    private MutableObjectLongMap<TId> deletedItemVersions;
    private Map<TId, Object> locks;
    private ObjectSerializer<TId> itemIdSerializer;
    private ObjectSerializer<TItem> itemSerializer;
    private ReentrantLock globalLock;
    private GenericObjectPool<ArrayBitSet> visitedBitSetPool;
    private ArrayBitSet excludedCandidates;
    private ExactView exactView;

    private HnswIndex(RefinedBuilder<TId, TVector, TItem, TDistance> builder) {
        this.immutable = builder.immutable;
        this.dimensions = builder.dimensions;
        this.maxItemCount = builder.maxItemCount;
        this.distanceFunction = builder.distanceFunction;
        this.distanceComparator = builder.distanceComparator;
        this.maxValueDistanceComparator = new MaxValueComparator<TDistance>(this.distanceComparator);
        this.m = builder.m;
        this.maxM = builder.m;
        this.maxM0 = builder.m * 2;
        this.levelLambda = 1.0 / Math.log(this.m);
        this.efConstruction = Math.max(builder.efConstruction, this.m);
        this.ef = builder.ef;
        this.removeEnabled = builder.removeEnabled;
        this.nodes = new AtomicReferenceArray(this.maxItemCount);
        this.lookup = new ObjectIntHashMap();
        this.deletedItemVersions = new ObjectLongHashMap();
        this.locks = new HashMap<TId, Object>();
        this.itemIdSerializer = ((RefinedBuilder)builder).itemIdSerializer;
        this.itemSerializer = ((RefinedBuilder)builder).itemSerializer;
        this.globalLock = new ReentrantLock();
        this.visitedBitSetPool = new GenericObjectPool<ArrayBitSet>(() -> new ArrayBitSet(this.maxItemCount), Runtime.getRuntime().availableProcessors());
        this.excludedCandidates = new ArrayBitSet(this.maxItemCount);
        this.exactView = new ExactView();
    }

    @Override
    public int size() {
        this.globalLock.lock();
        try {
            int n = this.lookup.size();
            return n;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TItem> get(TId id) {
        this.globalLock.lock();
        try {
            int nodeId = this.lookup.getIfAbsent(id, -1);
            if (nodeId == -1) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional optional = Optional.of(this.nodes.get((int)nodeId).item);
            return optional;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TItem> items() {
        this.globalLock.lock();
        try {
            ArrayList results = new ArrayList(this.size());
            ItemIterator iter = new ItemIterator();
            while (iter.hasNext()) {
                results.add(iter.next());
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(TId id, long version) {
        if (!this.removeEnabled) {
            return false;
        }
        this.globalLock.lock();
        try {
            int internalNodeId = this.lookup.getIfAbsent(id, -1);
            if (internalNodeId == -1) {
                boolean bl = false;
                return bl;
            }
            Node<TItem> node = this.nodes.get(internalNodeId);
            if (version < ((Item)node.item).version()) {
                boolean bl = false;
                return bl;
            }
            node.deleted = true;
            this.lookup.remove(id);
            this.deletedItemVersions.put(id, version);
            boolean bl = true;
            return bl;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean add(TItem item) {
        int levelM;
        if (this.immutable) {
            throw new UnsupportedOperationException("Index is immutable");
        }
        if (item.dimensions() != this.dimensions) {
            throw new IllegalArgumentException("Item does not have dimensionality of : " + this.dimensions);
        }
        int randomLevel = this.assignLevel(item.id(), this.levelLambda);
        IntArrayList[] connections = new IntArrayList[randomLevel + 1];
        for (int level = 0; level <= randomLevel; ++level) {
            levelM = randomLevel == 0 ? this.maxM0 : this.maxM;
            connections[level] = new IntArrayList(levelM);
        }
        this.globalLock.lock();
        try {
            int existingNodeId = this.lookup.getIfAbsent(item.id(), -1);
            if (existingNodeId != -1) {
                if (!this.removeEnabled) {
                    levelM = 0;
                    return levelM != 0;
                }
                Node<TItem> node = this.nodes.get(existingNodeId);
                if (item.version() < ((Item)node.item).version()) {
                    boolean bl = false;
                    return bl;
                }
                if (Objects.deepEquals(((Item)node.item).vector(), item.vector())) {
                    node.item = item;
                    boolean bl = true;
                    return bl;
                }
                this.remove(item.id(), item.version());
            } else if (item.version() < this.deletedItemVersions.getIfAbsent(item.id(), -1L)) {
                boolean node = false;
                return node;
            }
            if (this.nodeCount >= this.maxItemCount) {
                throw new SizeLimitExceededException("The number of elements exceeds the specified limit.");
            }
            int newNodeId = this.nodeCount++;
            ArrayBitSet arrayBitSet = this.excludedCandidates;
            synchronized (arrayBitSet) {
                this.excludedCandidates.add(newNodeId);
            }
            Node<TItem> newNode = new Node<TItem>(newNodeId, (MutableIntList[])connections, item, false);
            this.nodes.set(newNodeId, newNode);
            this.lookup.put(item.id(), newNodeId);
            this.deletedItemVersions.remove(item.id());
            Object lock = this.locks.computeIfAbsent(item.id(), k -> new Object());
            Node<TItem> entryPointCopy = this.entryPoint;
            try {
                Object object = lock;
                synchronized (object) {
                    Node<TItem> node = newNode;
                    synchronized (node) {
                        Node<TItem> currObj;
                        if (this.entryPoint != null && randomLevel <= this.entryPoint.maxLevel()) {
                            this.globalLock.unlock();
                        }
                        if ((currObj = entryPointCopy) != null) {
                            if (newNode.maxLevel() < entryPointCopy.maxLevel()) {
                                TDistance curDist = this.distanceFunction.distance(item.vector(), ((Item)currObj.item).vector());
                                for (int activeLevel = entryPointCopy.maxLevel(); activeLevel > newNode.maxLevel(); --activeLevel) {
                                    boolean changed = true;
                                    while (changed) {
                                        changed = false;
                                        Node<TItem> node2 = currObj;
                                        synchronized (node2) {
                                            MutableIntList candidateConnections = currObj.connections[activeLevel];
                                            for (int i = 0; i < candidateConnections.size(); ++i) {
                                                int candidateId = candidateConnections.get(i);
                                                Node<TItem> candidateNode = this.nodes.get(candidateId);
                                                TDistance candidateDistance = this.distanceFunction.distance(item.vector(), ((Item)candidateNode.item).vector());
                                                if (!this.lt(candidateDistance, curDist)) continue;
                                                curDist = candidateDistance;
                                                currObj = candidateNode;
                                                changed = true;
                                            }
                                        }
                                    }
                                }
                            }
                            for (int level = Math.min(randomLevel, entryPointCopy.maxLevel()); level >= 0; --level) {
                                PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates = this.searchBaseLayer(currObj, item.vector(), this.efConstruction, level);
                                if (entryPointCopy.deleted) {
                                    TDistance distance = this.distanceFunction.distance(item.vector(), ((Item)entryPointCopy.item).vector());
                                    topCandidates.add(new NodeIdAndDistance<TDistance>(entryPointCopy.id, distance, this.maxValueDistanceComparator));
                                    if (topCandidates.size() > this.efConstruction) {
                                        topCandidates.poll();
                                    }
                                }
                                this.mutuallyConnectNewElement(newNode, topCandidates, level);
                            }
                        }
                        if (this.entryPoint == null || newNode.maxLevel() > entryPointCopy.maxLevel()) {
                            this.entryPoint = newNode;
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ArrayBitSet arrayBitSet2 = this.excludedCandidates;
                synchronized (arrayBitSet2) {
                    this.excludedCandidates.remove(newNodeId);
                }
            }
        }
        finally {
            if (this.globalLock.isHeldByCurrentThread()) {
                this.globalLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutuallyConnectNewElement(Node<TItem> newNode, PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates, int level) {
        int bestN = level == 0 ? this.maxM0 : this.maxM;
        int newNodeId = newNode.id;
        Object newItemVector = ((Item)newNode.item).vector();
        MutableIntList newItemConnections = newNode.connections[level];
        this.getNeighborsByHeuristic2(topCandidates, this.m);
        while (!topCandidates.isEmpty()) {
            Node<TItem> neighbourNode;
            int selectedNeighbourId = topCandidates.poll().nodeId;
            ArrayBitSet arrayBitSet = this.excludedCandidates;
            synchronized (arrayBitSet) {
                if (this.excludedCandidates.contains(selectedNeighbourId)) {
                    continue;
                }
            }
            newItemConnections.add(selectedNeighbourId);
            Node<TItem> node = neighbourNode = this.nodes.get(selectedNeighbourId);
            synchronized (node) {
                Object neighbourVector = ((Item)neighbourNode.item).vector();
                MutableIntList neighbourConnectionsAtLevel = neighbourNode.connections[level];
                if (neighbourConnectionsAtLevel.size() < bestN) {
                    neighbourConnectionsAtLevel.add(newNodeId);
                } else {
                    TDistance dMax = this.distanceFunction.distance(newItemVector, ((Item)neighbourNode.item).vector());
                    Comparator comparator = Comparator.naturalOrder().reversed();
                    PriorityQueue<NodeIdAndDistance<TDistance>> candidates = new PriorityQueue<NodeIdAndDistance<TDistance>>(comparator);
                    candidates.add(new NodeIdAndDistance<TDistance>(newNodeId, dMax, this.maxValueDistanceComparator));
                    neighbourConnectionsAtLevel.forEach((IntProcedure & Serializable)id -> {
                        TDistance dist = this.distanceFunction.distance(neighbourVector, ((Item)this.nodes.get((int)id).item).vector());
                        candidates.add(new NodeIdAndDistance<TDistance>(id, dist, this.maxValueDistanceComparator));
                    });
                    this.getNeighborsByHeuristic2(candidates, bestN);
                    neighbourConnectionsAtLevel.clear();
                    while (!candidates.isEmpty()) {
                        neighbourConnectionsAtLevel.add(candidates.poll().nodeId);
                    }
                }
            }
        }
    }

    private void getNeighborsByHeuristic2(PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates, int m) {
        if (topCandidates.size() < m) {
            return;
        }
        PriorityQueue<NodeIdAndDistance<TDistance>> queueClosest = new PriorityQueue<NodeIdAndDistance<TDistance>>();
        ArrayList<NodeIdAndDistance> returnList = new ArrayList<NodeIdAndDistance>();
        while (!topCandidates.isEmpty()) {
            queueClosest.add(topCandidates.poll());
        }
        while (!queueClosest.isEmpty() && returnList.size() < m) {
            NodeIdAndDistance currentPair = (NodeIdAndDistance)queueClosest.poll();
            Object distToQuery = currentPair.distance;
            boolean good = true;
            for (NodeIdAndDistance secondPair : returnList) {
                TDistance curdist = this.distanceFunction.distance(((Item)this.nodes.get((int)secondPair.nodeId).item).vector(), ((Item)this.nodes.get((int)currentPair.nodeId).item).vector());
                if (!this.lt(curdist, distToQuery)) continue;
                good = false;
                break;
            }
            if (!good) continue;
            returnList.add(currentPair);
        }
        topCandidates.addAll(returnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SearchResult<TItem, TDistance>> findNearest(TVector destination, int k) {
        Node<TItem> entryPointCopy;
        if (this.entryPoint == null) {
            return Collections.emptyList();
        }
        Node<TItem> currObj = entryPointCopy = this.entryPoint;
        TDistance curDist = this.distanceFunction.distance(destination, ((Item)currObj.item).vector());
        for (int activeLevel = entryPointCopy.maxLevel(); activeLevel > 0; --activeLevel) {
            boolean changed = true;
            while (changed) {
                changed = false;
                Node<TItem> node = currObj;
                synchronized (node) {
                    MutableIntList candidateConnections = currObj.connections[activeLevel];
                    for (int i = 0; i < candidateConnections.size(); ++i) {
                        int candidateId = candidateConnections.get(i);
                        TDistance candidateDistance = this.distanceFunction.distance(destination, ((Item)this.nodes.get((int)candidateId).item).vector());
                        if (!this.lt(candidateDistance, curDist)) continue;
                        curDist = candidateDistance;
                        currObj = this.nodes.get(candidateId);
                        changed = true;
                    }
                }
            }
        }
        PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates = this.searchBaseLayer(currObj, destination, Math.max(this.ef, k), 0);
        while (topCandidates.size() > k) {
            topCandidates.poll();
        }
        ArrayList<SearchResult<TItem, TDistance>> results = new ArrayList<SearchResult<TItem, TDistance>>(topCandidates.size());
        while (!topCandidates.isEmpty()) {
            NodeIdAndDistance<TDistance> pair = topCandidates.poll();
            results.add(0, new SearchResult(this.nodes.get((int)pair.nodeId).item, pair.distance, this.maxValueDistanceComparator));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult<TItem, TDistance>> findNearestByIds(TVector destination, int k, Set<TId> includedIds) {
        Node<TItem> entryPointCopy;
        if (this.entryPoint == null) {
            return Collections.emptyList();
        }
        Node<TItem> currObj = entryPointCopy = this.entryPoint;
        TDistance curDist = this.distanceFunction.distance(destination, ((Item)currObj.item).vector());
        for (int activeLevel = entryPointCopy.maxLevel(); activeLevel > 0; --activeLevel) {
            boolean changed = true;
            while (changed) {
                changed = false;
                Node<TItem> node = currObj;
                synchronized (node) {
                    MutableIntList candidateConnections = currObj.connections[activeLevel];
                    for (int i = 0; i < candidateConnections.size(); ++i) {
                        TDistance candidateDistance;
                        int candidateId = candidateConnections.get(i);
                        Node<TItem> candidateNode = this.nodes.get(candidateId);
                        if (!includedIds.contains(((Item)candidateNode.item).id()) || !this.lt(candidateDistance = this.distanceFunction.distance(destination, ((Item)candidateNode.item).vector()), curDist)) continue;
                        curDist = candidateDistance;
                        currObj = candidateNode;
                        changed = true;
                    }
                }
            }
        }
        PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates = this.searchBaseLayerByIds(currObj, destination, Math.max(this.ef, k), 0, includedIds);
        while (topCandidates.size() > k) {
            topCandidates.poll();
        }
        ArrayList<SearchResult<TItem, TDistance>> results = new ArrayList<SearchResult<TItem, TDistance>>(topCandidates.size());
        while (!topCandidates.isEmpty()) {
            NodeIdAndDistance<TDistance> pair = topCandidates.poll();
            results.add(0, new SearchResult(this.nodes.get((int)pair.nodeId).item, pair.distance, this.maxValueDistanceComparator));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSize) {
        this.globalLock.lock();
        try {
            this.maxItemCount = newSize;
            this.visitedBitSetPool = new GenericObjectPool<ArrayBitSet>(() -> new ArrayBitSet(this.maxItemCount), Runtime.getRuntime().availableProcessors());
            AtomicReferenceArray<Node<TItem>> newNodes = new AtomicReferenceArray<Node<TItem>>(newSize);
            for (int i = 0; i < this.nodes.length(); ++i) {
                newNodes.set(i, this.nodes.get(i));
            }
            this.nodes = newNodes;
            this.excludedCandidates = new ArrayBitSet(this.excludedCandidates, newSize);
        }
        finally {
            this.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PriorityQueue<NodeIdAndDistance<TDistance>> searchBaseLayer(Node<TItem> entryPointNode, TVector destination, int k, int layer) {
        ArrayBitSet visitedBitSet = this.visitedBitSetPool.borrowObject();
        try {
            Object lowerBound;
            PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates = new PriorityQueue<NodeIdAndDistance<TDistance>>(Comparator.naturalOrder().reversed());
            PriorityQueue<NodeIdAndDistance<TDistance>> candidateSet = new PriorityQueue<NodeIdAndDistance<TDistance>>();
            if (!entryPointNode.deleted) {
                TDistance distance = this.distanceFunction.distance(destination, ((Item)entryPointNode.item).vector());
                NodeIdAndDistance<TDistance> pair = new NodeIdAndDistance<TDistance>(entryPointNode.id, distance, this.maxValueDistanceComparator);
                topCandidates.add(pair);
                lowerBound = distance;
                candidateSet.add(pair);
            } else {
                lowerBound = MaxValueComparator.maxValue();
                NodeIdAndDistance pair = new NodeIdAndDistance(entryPointNode.id, lowerBound, this.maxValueDistanceComparator);
                candidateSet.add(pair);
            }
            visitedBitSet.add(entryPointNode.id);
            while (!candidateSet.isEmpty()) {
                Node<TItem> node;
                NodeIdAndDistance currentPair = (NodeIdAndDistance)candidateSet.poll();
                if (this.gt(currentPair.distance, lowerBound)) break;
                Node<TItem> node2 = node = this.nodes.get(currentPair.nodeId);
                synchronized (node2) {
                    MutableIntList candidates = node.connections[layer];
                    for (int i = 0; i < candidates.size(); ++i) {
                        int candidateId = candidates.get(i);
                        if (visitedBitSet.contains(candidateId)) continue;
                        visitedBitSet.add(candidateId);
                        Node<TItem> candidateNode = this.nodes.get(candidateId);
                        TDistance candidateDistance = this.distanceFunction.distance(destination, ((Item)candidateNode.item).vector());
                        if (topCandidates.size() >= k && !this.gt(lowerBound, candidateDistance)) continue;
                        NodeIdAndDistance<TDistance> candidatePair = new NodeIdAndDistance<TDistance>(candidateId, candidateDistance, this.maxValueDistanceComparator);
                        candidateSet.add(candidatePair);
                        if (!candidateNode.deleted) {
                            topCandidates.add(candidatePair);
                        }
                        if (topCandidates.size() > k) {
                            topCandidates.poll();
                        }
                        if (topCandidates.isEmpty()) continue;
                        lowerBound = topCandidates.peek().distance;
                    }
                }
            }
            PriorityQueue<NodeIdAndDistance<TDistance>> priorityQueue = topCandidates;
            return priorityQueue;
        }
        finally {
            visitedBitSet.clear();
            this.visitedBitSetPool.returnObject(visitedBitSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PriorityQueue<NodeIdAndDistance<TDistance>> searchBaseLayerByIds(Node<TItem> entryPointNode, TVector destination, int k, int layer, Set<TId> includedIds) {
        ArrayBitSet visitedBitSet = this.visitedBitSetPool.borrowObject();
        try {
            Object lowerBound;
            PriorityQueue<NodeIdAndDistance<TDistance>> topCandidates = new PriorityQueue<NodeIdAndDistance<TDistance>>(Comparator.naturalOrder().reversed());
            PriorityQueue<NodeIdAndDistance<TDistance>> candidateSet = new PriorityQueue<NodeIdAndDistance<TDistance>>();
            if (!entryPointNode.deleted && includedIds.contains(((Item)entryPointNode.item).id())) {
                TDistance distance = this.distanceFunction.distance(destination, ((Item)entryPointNode.item).vector());
                NodeIdAndDistance<TDistance> pair = new NodeIdAndDistance<TDistance>(entryPointNode.id, distance, this.maxValueDistanceComparator);
                topCandidates.add(pair);
                lowerBound = distance;
                candidateSet.add(pair);
            } else {
                lowerBound = MaxValueComparator.maxValue();
                NodeIdAndDistance pair = new NodeIdAndDistance(entryPointNode.id, lowerBound, this.maxValueDistanceComparator);
                candidateSet.add(pair);
            }
            visitedBitSet.add(entryPointNode.id);
            while (!candidateSet.isEmpty()) {
                Node<TItem> node;
                NodeIdAndDistance currentPair = (NodeIdAndDistance)candidateSet.poll();
                if (this.gt(currentPair.distance, lowerBound)) break;
                Node<TItem> node2 = node = this.nodes.get(currentPair.nodeId);
                synchronized (node2) {
                    MutableIntList candidates = node.connections[layer];
                    for (int i = 0; i < candidates.size(); ++i) {
                        int candidateId = candidates.get(i);
                        if (visitedBitSet.contains(candidateId)) continue;
                        visitedBitSet.add(candidateId);
                        Node<TItem> candidateNode = this.nodes.get(candidateId);
                        if (!includedIds.contains(((Item)candidateNode.item).id())) continue;
                        TDistance candidateDistance = this.distanceFunction.distance(destination, ((Item)candidateNode.item).vector());
                        if (topCandidates.size() >= k && !this.gt(lowerBound, candidateDistance)) continue;
                        NodeIdAndDistance<TDistance> candidatePair = new NodeIdAndDistance<TDistance>(candidateId, candidateDistance, this.maxValueDistanceComparator);
                        candidateSet.add(candidatePair);
                        if (!candidateNode.deleted) {
                            topCandidates.add(candidatePair);
                        }
                        if (topCandidates.size() > k) {
                            topCandidates.poll();
                        }
                        if (topCandidates.isEmpty()) continue;
                        lowerBound = topCandidates.peek().distance;
                    }
                }
            }
            PriorityQueue<NodeIdAndDistance<TDistance>> priorityQueue = topCandidates;
            return priorityQueue;
        }
        finally {
            visitedBitSet.clear();
            this.visitedBitSetPool.returnObject(visitedBitSet);
        }
    }

    public Index<TId, TVector, TItem, TDistance> asExactIndex() {
        return this.exactView;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getM() {
        return this.m;
    }

    public int getEf() {
        return this.ef;
    }

    public void setEf(int ef) {
        this.ef = ef;
    }

    public int getEfConstruction() {
        return this.efConstruction;
    }

    public DistanceFunction<TVector, TDistance> getDistanceFunction() {
        return this.distanceFunction;
    }

    public Comparator<TDistance> getDistanceComparator() {
        return this.distanceComparator;
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    public ObjectSerializer<TId> getItemIdSerializer() {
        return this.itemIdSerializer;
    }

    public ObjectSerializer<TItem> getItemSerializer() {
        return this.itemSerializer;
    }

    @Override
    public void save(OutputStream out) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(this);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(2);
        oos.writeInt(this.dimensions);
        oos.writeObject(this.distanceFunction);
        oos.writeObject(this.distanceComparator);
        oos.writeObject(this.itemIdSerializer);
        oos.writeObject(this.itemSerializer);
        oos.writeInt(this.maxItemCount);
        oos.writeInt(this.m);
        oos.writeInt(this.maxM);
        oos.writeInt(this.maxM0);
        oos.writeDouble(this.levelLambda);
        oos.writeInt(this.ef);
        oos.writeInt(this.efConstruction);
        oos.writeBoolean(this.removeEnabled);
        oos.writeInt(this.nodeCount);
        this.writeMutableObjectIntMap(oos, this.lookup);
        this.writeMutableObjectLongMap(oos, this.deletedItemVersions);
        this.writeNodesArray(oos, this.nodes);
        oos.writeInt(this.entryPoint == null ? -1 : this.entryPoint.id);
        oos.writeBoolean(this.immutable);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        byte version = ois.readByte();
        this.dimensions = ois.readInt();
        this.distanceFunction = (DistanceFunction)ois.readObject();
        this.distanceComparator = (Comparator)ois.readObject();
        this.maxValueDistanceComparator = new MaxValueComparator<TDistance>(this.distanceComparator);
        this.itemIdSerializer = (ObjectSerializer)ois.readObject();
        this.itemSerializer = (ObjectSerializer)ois.readObject();
        this.maxItemCount = ois.readInt();
        this.m = ois.readInt();
        this.maxM = ois.readInt();
        this.maxM0 = ois.readInt();
        this.levelLambda = ois.readDouble();
        this.ef = ois.readInt();
        this.efConstruction = ois.readInt();
        this.removeEnabled = ois.readBoolean();
        this.nodeCount = ois.readInt();
        this.lookup = HnswIndex.readMutableObjectIntMap(ois, this.itemIdSerializer);
        this.deletedItemVersions = HnswIndex.readMutableObjectLongMap(ois, this.itemIdSerializer);
        this.nodes = HnswIndex.readNodesArray(ois, this.itemSerializer, this.maxM0, this.maxM);
        int entrypointNodeId = ois.readInt();
        this.immutable = version != 1 && ois.readBoolean();
        this.entryPoint = entrypointNodeId == -1 ? null : this.nodes.get(entrypointNodeId);
        this.globalLock = new ReentrantLock();
        this.visitedBitSetPool = new GenericObjectPool<ArrayBitSet>(() -> new ArrayBitSet(this.maxItemCount), Runtime.getRuntime().availableProcessors());
        this.excludedCandidates = new ArrayBitSet(this.maxItemCount);
        this.locks = new HashMap<TId, Object>();
        this.exactView = new ExactView();
    }

    private void writeMutableObjectIntMap(ObjectOutputStream oos, MutableObjectIntMap<TId> map) throws IOException {
        oos.writeInt(map.size());
        for (ObjectIntPair pair : map.keyValuesView()) {
            this.itemIdSerializer.write(pair.getOne(), oos);
            oos.writeInt(pair.getTwo());
        }
    }

    private void writeMutableObjectLongMap(ObjectOutputStream oos, MutableObjectLongMap<TId> map) throws IOException {
        oos.writeInt(map.size());
        for (ObjectLongPair pair : map.keyValuesView()) {
            this.itemIdSerializer.write(pair.getOne(), oos);
            oos.writeLong(pair.getTwo());
        }
    }

    private void writeNodesArray(ObjectOutputStream oos, AtomicReferenceArray<Node<TItem>> nodes) throws IOException {
        oos.writeInt(nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            this.writeNode(oos, nodes.get(i));
        }
    }

    private void writeNode(ObjectOutputStream oos, Node<TItem> node) throws IOException {
        if (node == null) {
            oos.writeInt(-1);
        } else {
            oos.writeInt(node.id);
            oos.writeInt(node.connections.length);
            for (MutableIntList connections : node.connections) {
                oos.writeInt(connections.size());
                for (int j = 0; j < connections.size(); ++j) {
                    oos.writeInt(connections.get(j));
                }
            }
            this.itemSerializer.write(node.item, oos);
            oos.writeBoolean(node.deleted);
        }
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(File file) throws IOException {
        return HnswIndex.load(new FileInputStream(file));
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(File file, ClassLoader classLoader) throws IOException {
        return HnswIndex.load(new FileInputStream(file), classLoader);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(Path path) throws IOException {
        return HnswIndex.load(Files.newInputStream(path, new OpenOption[0]));
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(Path path, ClassLoader classLoader) throws IOException {
        return HnswIndex.load(Files.newInputStream(path, new OpenOption[0]), classLoader);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(InputStream inputStream) throws IOException {
        return HnswIndex.load(inputStream, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> load(InputStream inputStream, ClassLoader classLoader) throws IOException {
        try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, inputStream);){
            HnswIndex hnswIndex = (HnswIndex)ois.readObject();
            return hnswIndex;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not read input file.", e);
        }
    }

    private static IntArrayList readIntArrayList(ObjectInputStream ois, int initialSize) throws IOException {
        int size = ois.readInt();
        IntArrayList list = new IntArrayList(initialSize);
        for (int j = 0; j < size; ++j) {
            list.add(ois.readInt());
        }
        return list;
    }

    private static <TItem> Node<TItem> readNode(ObjectInputStream ois, ObjectSerializer<TItem> itemSerializer, int maxM0, int maxM) throws IOException, ClassNotFoundException {
        int id = ois.readInt();
        if (id == -1) {
            return null;
        }
        int connectionsSize = ois.readInt();
        MutableIntList[] connections = new MutableIntList[connectionsSize];
        for (int i = 0; i < connectionsSize; ++i) {
            int levelM = i == 0 ? maxM0 : maxM;
            connections[i] = HnswIndex.readIntArrayList(ois, levelM);
        }
        TItem item = itemSerializer.read(ois);
        boolean deleted = ois.readBoolean();
        return new Node<TItem>(id, connections, item, deleted);
    }

    private static <TItem> AtomicReferenceArray<Node<TItem>> readNodesArray(ObjectInputStream ois, ObjectSerializer<TItem> itemSerializer, int maxM0, int maxM) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        AtomicReferenceArray<Node<TItem>> nodes = new AtomicReferenceArray<Node<TItem>>(size);
        for (int i = 0; i < nodes.length(); ++i) {
            nodes.set(i, HnswIndex.readNode(ois, itemSerializer, maxM0, maxM));
        }
        return nodes;
    }

    private static <TId> MutableObjectIntMap<TId> readMutableObjectIntMap(ObjectInputStream ois, ObjectSerializer<TId> itemIdSerializer) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        ObjectIntHashMap map = new ObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            TId key = itemIdSerializer.read(ois);
            int value = ois.readInt();
            map.put(key, value);
        }
        return map;
    }

    private static <TId> MutableObjectLongMap<TId> readMutableObjectLongMap(ObjectInputStream ois, ObjectSerializer<TId> itemIdSerializer) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        ObjectLongHashMap map = new ObjectLongHashMap(size);
        for (int i = 0; i < size; ++i) {
            TId key = itemIdSerializer.read(ois);
            long value = ois.readLong();
            map.put(key, value);
        }
        return map;
    }

    public static <TVector, TDistance extends Comparable<TDistance>> Builder<TVector, TDistance> newBuilder(int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, int maxItemCount) {
        Comparator distanceComparator = Comparator.naturalOrder();
        return new Builder<TVector, TDistance>(false, dimensions, distanceFunction, distanceComparator, maxItemCount);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> HnswIndex<TId, TVector, TItem, TDistance> empty() {
        Builder builder = new Builder(true, 0, new DistanceFunction<TVector, TDistance>(){

            @Override
            public TDistance distance(TVector u, TVector v) {
                throw new UnsupportedOperationException();
            }
        }, new DummyComparator(), 0);
        return builder.build();
    }

    public static <TVector, TDistance> Builder<TVector, TDistance> newBuilder(int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator, int maxItemCount) {
        return new Builder<TVector, TDistance>(false, dimensions, distanceFunction, distanceComparator, maxItemCount);
    }

    private int assignLevel(TId value, double lambda) {
        int hashCode = value.hashCode();
        byte[] bytes = new byte[]{(byte)(hashCode >> 24), (byte)(hashCode >> 16), (byte)(hashCode >> 8), (byte)hashCode};
        double random = Math.abs((double)Murmur3.hash32(bytes) / 2.147483647E9);
        double r = -Math.log(random) * lambda;
        return (int)r;
    }

    private boolean lt(TDistance x, TDistance y) {
        return this.maxValueDistanceComparator.compare(x, y) < 0;
    }

    private boolean gt(TDistance x, TDistance y) {
        return this.maxValueDistanceComparator.compare(x, y) > 0;
    }

    public static class RefinedBuilder<TId, TVector, TItem extends Item<TId, TVector>, TDistance>
    extends BuilderBase<RefinedBuilder<TId, TVector, TItem, TDistance>, TVector, TDistance> {
        private ObjectSerializer<TId> itemIdSerializer;
        private ObjectSerializer<TItem> itemSerializer;

        RefinedBuilder(boolean immutable, int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator, int maxItemCount, int m, int ef, int efConstruction, boolean removeEnabled, ObjectSerializer<TId> itemIdSerializer, ObjectSerializer<TItem> itemSerializer) {
            super(immutable, dimensions, distanceFunction, distanceComparator, maxItemCount);
            this.m = m;
            this.ef = ef;
            this.efConstruction = efConstruction;
            this.removeEnabled = removeEnabled;
            this.itemIdSerializer = itemIdSerializer;
            this.itemSerializer = itemSerializer;
        }

        @Override
        RefinedBuilder<TId, TVector, TItem, TDistance> self() {
            return this;
        }

        public RefinedBuilder<TId, TVector, TItem, TDistance> withCustomSerializers(ObjectSerializer<TId> itemIdSerializer, ObjectSerializer<TItem> itemSerializer) {
            this.itemIdSerializer = itemIdSerializer;
            this.itemSerializer = itemSerializer;
            return this;
        }

        public HnswIndex<TId, TVector, TItem, TDistance> build() {
            return new HnswIndex(this);
        }
    }

    public static class Builder<TVector, TDistance>
    extends BuilderBase<Builder<TVector, TDistance>, TVector, TDistance> {
        Builder(boolean immutable, int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator, int maxItemCount) {
            super(immutable, dimensions, distanceFunction, distanceComparator, maxItemCount);
        }

        @Override
        Builder<TVector, TDistance> self() {
            return this;
        }

        public <TId, TItem extends Item<TId, TVector>> RefinedBuilder<TId, TVector, TItem, TDistance> withCustomSerializers(ObjectSerializer<TId> itemIdSerializer, ObjectSerializer<TItem> itemSerializer) {
            return new RefinedBuilder(this.immutable, this.dimensions, this.distanceFunction, this.distanceComparator, this.maxItemCount, this.m, this.ef, this.efConstruction, this.removeEnabled, itemIdSerializer, itemSerializer);
        }

        public <TId, TItem extends Item<TId, TVector>> HnswIndex<TId, TVector, TItem, TDistance> build() {
            JavaObjectSerializer itemIdSerializer = new JavaObjectSerializer();
            JavaObjectSerializer itemSerializer = new JavaObjectSerializer();
            return this.withCustomSerializers(itemIdSerializer, itemSerializer).build();
        }
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder, TVector, TDistance>, TVector, TDistance> {
        public static final int DEFAULT_M = 10;
        public static final int DEFAULT_EF = 10;
        public static final int DEFAULT_EF_CONSTRUCTION = 200;
        public static final boolean DEFAULT_REMOVE_ENABLED = false;
        boolean immutable;
        int dimensions;
        DistanceFunction<TVector, TDistance> distanceFunction;
        Comparator<TDistance> distanceComparator;
        int maxItemCount;
        int m = 10;
        int ef = 10;
        int efConstruction = 200;
        boolean removeEnabled = false;

        BuilderBase(boolean immutable, int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator, int maxItemCount) {
            this.immutable = immutable;
            this.dimensions = dimensions;
            this.distanceFunction = distanceFunction;
            this.distanceComparator = distanceComparator;
            this.maxItemCount = maxItemCount;
        }

        abstract TBuilder self();

        public TBuilder withM(int m) {
            this.m = m;
            return this.self();
        }

        public TBuilder withEfConstruction(int efConstruction) {
            this.efConstruction = efConstruction;
            return this.self();
        }

        public TBuilder withEf(int ef) {
            this.ef = ef;
            return this.self();
        }

        public TBuilder withRemoveEnabled() {
            this.removeEnabled = true;
            return this.self();
        }
    }

    static class MaxValueComparator<TDistance>
    implements Comparator<TDistance>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator<TDistance> delegate;

        MaxValueComparator(Comparator<TDistance> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(TDistance o1, TDistance o2) {
            return o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : this.delegate.compare(o1, o2));
        }

        static <TDistance> TDistance maxValue() {
            return null;
        }
    }

    static class NodeIdAndDistance<TDistance>
    implements Comparable<NodeIdAndDistance<TDistance>> {
        final int nodeId;
        final TDistance distance;
        final Comparator<TDistance> distanceComparator;

        NodeIdAndDistance(int nodeId, TDistance distance, Comparator<TDistance> distanceComparator) {
            this.nodeId = nodeId;
            this.distance = distance;
            this.distanceComparator = distanceComparator;
        }

        @Override
        public int compareTo(NodeIdAndDistance<TDistance> o) {
            return this.distanceComparator.compare(this.distance, o.distance);
        }
    }

    static class Node<TItem>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final int id;
        final MutableIntList[] connections;
        volatile TItem item;
        volatile boolean deleted;

        Node(int id, MutableIntList[] connections, TItem item, boolean deleted) {
            this.id = id;
            this.connections = connections;
            this.item = item;
            this.deleted = deleted;
        }

        int maxLevel() {
            return this.connections.length - 1;
        }
    }

    class ItemIterator
    implements Iterator<TItem> {
        private int done = 0;
        private int index = 0;

        ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.done < HnswIndex.this.size();
        }

        @Override
        public TItem next() {
            Node node;
            while ((node = (Node)HnswIndex.this.nodes.get(this.index++)) == null || node.deleted) {
            }
            ++this.done;
            return (Item)node.item;
        }
    }

    class ExactView
    implements Index<TId, TVector, TItem, TDistance> {
        private static final long serialVersionUID = 1L;

        ExactView() {
        }

        @Override
        public int size() {
            return HnswIndex.this.size();
        }

        @Override
        public Optional<TItem> get(TId tId) {
            return HnswIndex.this.get(tId);
        }

        @Override
        public Collection<TItem> items() {
            return HnswIndex.this.items();
        }

        @Override
        public List<SearchResult<TItem, TDistance>> findNearest(TVector vector, int k) {
            SearchResult result;
            Comparator comparator = Comparator.naturalOrder().reversed();
            PriorityQueue queue = new PriorityQueue(k, comparator);
            for (int i = 0; i < HnswIndex.this.nodeCount; ++i) {
                Node node = (Node)HnswIndex.this.nodes.get(i);
                if (node == null || node.deleted) continue;
                Object distance = HnswIndex.this.distanceFunction.distance(((Item)node.item).vector(), vector);
                SearchResult searchResult = new SearchResult(node.item, distance, HnswIndex.this.maxValueDistanceComparator);
                queue.add(searchResult);
                if (queue.size() <= k) continue;
                queue.poll();
            }
            ArrayList results = new ArrayList(queue.size());
            while ((result = (SearchResult)queue.poll()) != null) {
                results.add(0, result);
            }
            return results;
        }

        @Override
        public boolean add(TItem item) {
            return HnswIndex.this.add(item);
        }

        @Override
        public boolean remove(TId id, long version) {
            return HnswIndex.this.remove(id, version);
        }

        @Override
        public void save(OutputStream out) throws IOException {
            HnswIndex.this.save(out);
        }

        @Override
        public void save(File file) throws IOException {
            HnswIndex.this.save(file);
        }

        @Override
        public void save(Path path) throws IOException {
            HnswIndex.this.save(path);
        }

        @Override
        public void addAll(Collection<TItem> items) throws InterruptedException {
            HnswIndex.this.addAll(items);
        }

        @Override
        public void addAll(Collection<TItem> items, ProgressListener listener) throws InterruptedException {
            HnswIndex.this.addAll(items, listener);
        }

        @Override
        public void addAll(Collection<TItem> items, int numThreads, ProgressListener listener, int progressUpdateInterval) throws InterruptedException {
            HnswIndex.this.addAll(items, numThreads, listener, progressUpdateInterval);
        }
    }
}

