/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn.util;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;

public class GenericObjectPool<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayBlockingQueue<T> items;

    public GenericObjectPool(Supplier<T> supplier, int maxPoolSize) {
        this.items = new ArrayBlockingQueue(maxPoolSize);
        for (int i = 0; i < maxPoolSize; ++i) {
            this.items.add(supplier.get());
        }
    }

    public T borrowObject() {
        try {
            return this.items.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void returnObject(T item) {
        this.items.add(item);
    }
}

