/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.storage;

import com.google.common.collect.Lists;
import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.index.bm25.Bm25IndexManager;
import io.github.javpower.vectorex.keynote.index.scalar.ScalarIndexManager;
import io.github.javpower.vectorex.keynote.index.vector.VectorIndexManager;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorex.keynote.query.ConditionBuilder;
import io.github.javpower.vectorex.keynote.storage.DataStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStorage
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger(MapDBStorage.class);
    private final DB db;
    private final HTreeMap<String, DbData> map;
    private final ScalarIndexManager scalarIndexManager;
    private final Map<String, VectorIndexManager> vectorIndexManagers = new ConcurrentHashMap<String, VectorIndexManager>();
    private final Bm25IndexManager bm25IndexManager;

    public MapDBStorage(DB db, HTreeMap<String, DbData> map, int maxDataCount, List<VectorFiled> vectorFiled) {
        try {
            this.db = db;
            this.map = map;
            this.scalarIndexManager = new ScalarIndexManager();
            this.bm25IndexManager = new Bm25IndexManager();
            if (vectorFiled != null) {
                for (VectorFiled filed : vectorFiled) {
                    VectorIndexManager vectorIndexManager = new VectorIndexManager(filed.getDimensions(), maxDataCount, filed.getMetricType());
                    this.vectorIndexManagers.put(filed.getName(), vectorIndexManager);
                }
            }
            logger.info("MapDB storage initialized");
        }
        catch (Exception e) {
            logger.error("Failed to initialize MapDB storage", (Throwable)e);
            throw new RuntimeException("Failed to initialize MapDB storage", e);
        }
    }

    public HTreeMap<String, DbData> getMap() {
        return this.map;
    }

    @Override
    public void save(DbData data) {
        try {
            this.map.put((Object)data.getId(), (Object)data);
            this.scalarIndexManager.index(data);
            this.bm25IndexManager.index(data);
            if (data.getVectorFiled() != null) {
                for (VectorData vectorData : data.getVectorFiled()) {
                    this.vectorIndexManagers.get(vectorData.getName()).index(vectorData);
                }
            }
            this.db.commit();
            logger.debug("Saved vector data with ID: {}", (Object)data.getId());
        }
        catch (Exception e) {
            logger.error("Failed to save vector data with ID: {}", (Object)data.getId(), (Object)e);
            throw new RuntimeException("Failed to save vector data", e);
        }
    }

    @Override
    public void saveAll(List<DbData> dataList) {
        try {
            dataList.forEach(data -> {
                this.map.put((Object)data.getId(), data);
                this.scalarIndexManager.index((DbData)data);
                this.bm25IndexManager.index((DbData)data);
                if (data.getVectorFiled() != null) {
                    for (VectorData vectorData : data.getVectorFiled()) {
                        this.vectorIndexManagers.get(vectorData.getName()).index(vectorData);
                    }
                }
            });
            this.db.commit();
            logger.debug("Saved {} vector data entries", (Object)dataList.size());
        }
        catch (Exception e) {
            logger.error("Failed to save batch vector data", (Throwable)e);
            throw new RuntimeException("Failed to save batch vector data", e);
        }
    }

    @Override
    public void update(DbData data) {
        try {
            DbData oldData = (DbData)this.map.get((Object)data.getId());
            if (oldData != null) {
                this.scalarIndexManager.remove(oldData.getId());
                this.bm25IndexManager.remove(oldData.getId());
                if (oldData.getVectorFiled() != null) {
                    for (VectorData vectorData : oldData.getVectorFiled()) {
                        this.vectorIndexManagers.get(vectorData.getName()).remove(vectorData.id());
                    }
                }
            }
            this.map.put((Object)data.getId(), (Object)data);
            this.scalarIndexManager.index(data);
            this.bm25IndexManager.index(data);
            if (data.getVectorFiled() != null) {
                for (VectorData vectorData : data.getVectorFiled()) {
                    this.vectorIndexManagers.get(vectorData.getName()).index(vectorData);
                }
            }
            this.db.commit();
            logger.debug("Updated vector data with ID: {}", (Object)data.getId());
        }
        catch (Exception e) {
            logger.error("Failed to update vector data with ID: {}", (Object)data.getId(), (Object)e);
            throw new RuntimeException("Failed to update vector data", e);
        }
    }

    @Override
    public DbData get(String id) {
        DbData data = (DbData)this.map.get((Object)id);
        if (data == null) {
            logger.warn("Vector data with ID {} not found", (Object)id);
        }
        return data;
    }

    @Override
    public List<DbData> getAll() {
        return new ArrayList<DbData>(this.map.values());
    }

    @Override
    public void delete(String id) {
        try {
            DbData data = (DbData)this.map.get((Object)id);
            if (data != null) {
                this.scalarIndexManager.remove(data.getId());
                this.bm25IndexManager.remove(data.getId());
                if (data.getVectorFiled() != null) {
                    for (VectorData vectorData : data.getVectorFiled()) {
                        this.vectorIndexManagers.get(vectorData.getName()).remove(vectorData.id());
                    }
                }
                this.map.remove((Object)id);
                this.db.commit();
                logger.debug("Deleted vector data with ID: {}", (Object)id);
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete vector data with ID: {}", (Object)id, (Object)e);
            throw new RuntimeException("Failed to delete vector data", e);
        }
    }

    @Override
    public void deleteAll(List<String> ids) {
        try {
            ids.forEach(id -> {
                DbData data = (DbData)this.map.get(id);
                if (data != null) {
                    this.scalarIndexManager.remove(data.getId());
                    this.bm25IndexManager.remove(data.getId());
                    if (data.getVectorFiled() != null) {
                        for (VectorData vectorData : data.getVectorFiled()) {
                            this.vectorIndexManagers.get(vectorData.getName()).remove(vectorData.id());
                        }
                    }
                    this.map.remove(id);
                }
            });
            this.db.commit();
            logger.debug("Deleted {} vector data entries", (Object)ids.size());
        }
        catch (Exception e) {
            logger.error("Failed to delete batch vector data", (Throwable)e);
            throw new RuntimeException("Failed to delete batch vector data", e);
        }
    }

    @Override
    public void close() {
        try {
            this.db.close();
            logger.info("MapDB storage closed");
        }
        catch (Exception e) {
            logger.error("Failed to close MapDB storage", (Throwable)e);
            throw new RuntimeException("Failed to close MapDB storage", e);
        }
    }

    @Override
    public List<VectorSearchResult> search(String annsField, List<Float> queryVector, int k, ConditionBuilder conditionBuilder) {
        if (conditionBuilder == null) {
            VectorIndexManager vectorIndexManager = this.vectorIndexManagers.get(annsField);
            return vectorIndexManager.search(queryVector, k).stream().peek(v -> v.setData(this.scalarIndexManager.getDbDataById(v.getId()))).collect(Collectors.toList());
        }
        List<String> filteredIds = this.scalarIndexManager.search(conditionBuilder);
        if (filteredIds != null && filteredIds.size() > 0) {
            return this.vectorIndexManagers.get(annsField).search(queryVector, k, new HashSet<String>(filteredIds)).stream().peek(v -> v.setData(this.scalarIndexManager.getDbDataById(v.getId()))).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<VectorSearchResult> search(String annsField, String queryVector, int k, ConditionBuilder conditionBuilder) {
        if (conditionBuilder == null) {
            return this.bm25IndexManager.search(annsField, queryVector, k).stream().peek(v -> v.setData(this.scalarIndexManager.getDbDataById(v.getId()))).collect(Collectors.toList());
        }
        List<String> filteredIds = this.scalarIndexManager.search(conditionBuilder);
        if (filteredIds != null && filteredIds.size() > 0) {
            return this.bm25IndexManager.search(annsField, queryVector, k, new HashSet<String>(filteredIds)).stream().peek(v -> v.setData(this.scalarIndexManager.getDbDataById(v.getId()))).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<VectorSearchResult> query(ConditionBuilder conditionBuilder) {
        List<String> filteredIds = this.scalarIndexManager.search(conditionBuilder);
        return filteredIds.stream().map(this.scalarIndexManager::getDbDataById).map(v -> {
            VectorSearchResult result = new VectorSearchResult();
            result.setData((DbData)v);
            result.setId(v.getId());
            result.setScore(Float.valueOf(0.0f));
            return result;
        }).collect(Collectors.toList());
    }

    @Override
    public void loadDataIntoManagers(DbData data) {
        this.scalarIndexManager.index(data);
        this.bm25IndexManager.index(data);
        for (VectorData vectorData : data.getVectorFiled()) {
            this.vectorIndexManagers.get(vectorData.getName()).index(vectorData);
        }
    }
}

