<!DOCTYPE html>
<html>
<head>
    <title>字典表</title>
    <link rel="stylesheet" href="${base}/static/ms-admin/4.7.2/iconfont/iconfont.css"/>
    <#include "../../include/head-file.ftl">
</head>
<body>
<div id="index" v-cloak class="ms-index">
    <el-header class="ms-header" height="50px">
        <el-col :span="12">
            <@shiro.hasPermission name="mdiy:dict:save">
                <el-button type="primary" icon="el-icon-plus" size="mini" @click="save()">新增</el-button>
            </@shiro.hasPermission>
            <@shiro.hasPermission name="mdiy:dict:del">
                <el-button type="danger" icon="el-icon-delete" size="mini" @click="del(selectionList)"
                           :disabled="!selectionList.length">删除
                </el-button>
            </@shiro.hasPermission>
        </el-col>
    </el-header>
    <div class="ms-search" style="padding: 20px 10px 0 10px;">
        <el-row>
            <el-form :model="form" ref="searchForm" label-width="60px" size="mini">
                <el-row>
                    <el-col :span="6">
                        <el-form-item  label="类型" prop="dictType">
                            <el-select v-model="form.dictType"
                                       :style="{width: '100%'}"
                                       :disabled="false"
                                       filterable
                                       default-first-option
                                       :multiple="false" :clearable="true"
                                       placeholder="请选择类型">
                                <el-option v-for='item in dictTypeOptions' :key="item.dictType" :value="item.dictType"
                                           :label="item.dictType"></el-option>
                            </el-select>
                        </el-form-item>
                    </el-col>
                    <el-col :span="18" style="text-align: right">
                        <el-button type="primary" icon="el-icon-search" size="mini"
                                   @click="loading=true;currentPage=1;list()">查询
                        </el-button>
                        <el-button @click="rest" icon="el-icon-refresh" size="mini">重置</el-button>
                    </el-col>
                </el-row>
            </el-form>
        </el-row>
    </div>
    <el-main class="ms-container">
        <el-table v-loading="loading" ref="multipleTable" height="calc(100% - 68px)" class="ms-table-pagination" border
                  :data="treeList" tooltip-effect="dark" @selection-change="handleSelectionChange">
            <template slot="empty">
                {{emptyText}}
            </template>
            <el-table-column type="selection" :selectable="isChecked" width="40"></el-table-column>
            <el-table-column label="标签名" align="left" prop="dictLabel">
            </el-table-column>
            <el-table-column label="类型" align="left" prop="dictType">
            </el-table-column>
            <el-table-column label="数据值" width="150" align="left" prop="dictValue">
            </el-table-column>
            <el-table-column label="排序" align="right" width="100" prop="dictSort">
            </el-table-column>
            <@shiro.hasPermission name="mdiy:dict:update">
                <el-table-column label="操作" fixed="right" align="center" width="180">
                    <template slot-scope="scope">
                        <el-link :underline="false" type="primary" size="medium" @click="save(scope.row.dictId)">编辑
                        </el-link>
                        <@shiro.hasPermission name="mdiy:dict:del">
                            <el-link :underline="false" v-if="scope.row.del != 3" type="primary"
                                     @click="del([scope.row])">删除
                            </el-link>
                        </@shiro.hasPermission>
                    </template>
                </el-table-column>
            </@shiro.hasPermission>
        </el-table>
        <el-pagination
                background
                :page-sizes="[5, 10, 20]"
                layout="total, sizes, prev, pager, next, jumper"
                :current-page.sync="currentPage"
                :page-size="pageSize"
                :total="total"
                class="ms-pagination"
                @current-change='currentChange'
                @size-change="sizeChange">
        </el-pagination>
    </el-main>
</div>
</body>

</html>
<script>
    var indexVue = new Vue({
        el: '#index',
        data: {
            treeList: [],
            //字典表列表
            selectionList: [],
            //字典表列表选中
            total: 0,
            //总记录数量
            pageSize: 10,
            //页面数量
            currentPage: 1,
            //初始页
            mananger: ms.manager,
            loading: true,
            emptyText: '',
            dictTypeOptions: [],
            //搜索表单
            form: {
                // 标签名
                dictLabel: '',
                // 类型
                dictType: '',
                // 数据值
                dictValue: '',
                // 子业务数据类型
                isChild: '',
                // 排序
                dictSort: '',
                // 备注信息
                dictRemarks: '',
                // 描述
                dictDescription: ''
            }
        },
        methods: {
            //查询列表
            list: function() {
                var that = this;
                var page = {
                    pageNo: that.currentPage,
                    pageSize: that.pageSize
                };
                var form = JSON.parse(JSON.stringify(that.form));

                for (key in form) {
                    if (!form[key]) {
                        delete form[key];
                    }
                }

                history.replaceState({
                    form: form,
                    page: page,
                    total: that.total
                }, "");
                setTimeout(function () {
                    ms.http.get(ms.manager + "/mdiy/dict/list.do", Object.assign({},that.form, page)).then(function (data) {
                        if (data.data.total <= 0) {
                            that.loading = false;
                            that.emptyText = '暂无数据';
                            that.treeList = [];
                        } else {
                            that.emptyText = '';
                            that.loading = false;
                            that.total = data.data.total;
                            that.treeList = data.data.rows;
                        }
                    }).catch(function (err) {
                        console.log(err);
                    });
                }, 500);
            },
            //字典表列表选中
            handleSelectionChange: function(val) {
                this.selectionList = val;
            },
            //删除
            del: function (row) {
                var that = this;
                that.$confirm('此操作将永久删除所选内容, 是否继续?', '提示', {
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    type: 'warning'
                }).then(function () {
                    ms.http.post(ms.manager + "/mdiy/dict/delete.do", row.length ? row : [row], {
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }).then(function (data) {
                        if (data.result) {
                            that.$notify({
                                type: 'success',
                                message: '删除成功!'
                            }); //删除成功，刷新列表

                            that.list();
                        } else {
                            that.$notify({
                                title: '失败',
                                message: data.msg,
                                type: 'warning'
                            });
                        }
                    });
                }).catch(function () {
                    that.$notify({
                        type: 'info',
                        message: '已取消删除'
                    });
                });
            },
            //新增
            save: function (dictId) {
                if (dictId) {
                    location.href = this.mananger + "/mdiy/dict/form.do?dictId=" + dictId;
                } else {
                    location.href = this.mananger + "/mdiy/dict/form.do";
                }
            },
            isChecked: function (row) {
                if (row.del == 3) {
                    return false;
                }

                return true;
            },
            //pageSize改变时会触发
            sizeChange: function (pagesize) {
                this.loading = true;
                this.pageSize = pagesize;
                this.list();
            },
            //currentPage改变时会触发
            currentChange: function (currentPage) {
                this.loading = true;
                this.currentPage = currentPage;
                this.list();
            },
            getDictType: function (isChild) {
                var that = this;
                that.form.dictType = '';
                ms.http.get(ms.manager + "/mdiy/dict/dictType.do?pageSize=999", isChild ? {
                    "isChild": isChild
                } : null).then(function (data) {
                    if (data.data.rows) {
                        that.dictTypeOptions = data.data.rows;
                    }
                }).catch(function (err) {
                    console.log(err);
                });
            },
            //重置表单
            rest: function () {
                this.currentPage = 1;
                this.loading = true;
                this.$refs.searchForm.resetFields();
                this.list();
            }
        },
        mounted: function () {
            if (history.hasOwnProperty("state")&&history.state) {
                this.form = history.state.form;
                this.total = history.state.total;
                this.currentPage = history.state.page.pageNo;
                this.pageSize = history.state.page.pageSize;
            }

            this.list();
            this.getDictType();
        }
    });
</script>
<style>
</style>
