package net.mingsoft.mdiy.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
	
/**
 * 字典表管理控制层
 * @author 铭飞开发团队
 * @version 
 * 版本号：1<br/>
 * 创建日期：2017-8-12 14:22:36<br/>
 * 历史修订：<br/>
 */
@Api(value = "字典表管理接口")
@Controller
@RequestMapping("/${ms.manager.path}/mdiy/dict")
public class DictAction extends net.mingsoft.mdiy.action.BaseAction{
	
	/**
	 * 注入字典表业务层
	 */	
	@Autowired
	private IDictBiz dictBiz;
	
	/**
	 * 返回主界面index
	 */
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request){
		return "/mdiy/dict/index";
	}
	
	/**
	 * 查询字典表列表
	 * @param dict 字典表实体
	 * <i>dict参数包含字段信息参考：</i><br/>
	 * dictId 编号<br/>
	 * dictAppId 应用编号<br/>
	 * dictValue 数据值<br/>
	 * dictLabel 标签名<br/>
	 * dictType 类型<br/>
	 * dictDescription 描述<br/>
	 * dictSort 排序（升序）<br/>
	 * dictParentId 父级编号<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新者<br/>
	 * updateDate 更新时间<br/>
	 * dictRemarks 备注信息<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>[<br/>
	 * { <br/>
	 * dictId: 编号<br/>
	 * dictAppId: 应用编号<br/>
	 * dictValue: 数据值<br/>
	 * dictLabel: 标签名<br/>
	 * dictType: 类型<br/>
	 * dictDescription: 描述<br/>
	 * dictSort: 排序（升序）<br/>
	 * dictParentId: 父级编号<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新者<br/>
	 * updateDate: 更新时间<br/>
	 * dictRemarks: 备注信息<br/>
	 * del: 删除标记<br/>
	 * }<br/>
	 * ]</dd><br/>	 
	 */
	@ApiOperation(value = "查询字典表列表接口")
	@ApiImplicitParams({
    	@ApiImplicitParam(name = "dictValue", value = "数据值", required =false,paramType="query"),
    	@ApiImplicitParam(name = "dictLabel", value = "标签名", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictType", value = "类型", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictDescription", value = "描述", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictSort", value = "排序（升序）", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictParentId", value = "父级编号", required = false,paramType="query"),
    	@ApiImplicitParam(name = "isChild", value = "子业务关联", required = false,paramType="query"),
    })
	@GetMapping("/list")
	@ResponseBody
	public ResultData list(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
		dict.setAppId(BasicUtil.getAppId());
		BasicUtil.startPage();
		List dictList = dictBiz.query(dict);
		return ResultData.build().success(new EUListBean(dictList,(int)BasicUtil.endPage(dictList).getTotal()));
	}

    @ApiOperation(value = "获取所有字典类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "isChild", value = "子业务关联", required = false,paramType="query"),
    })
    @GetMapping("/dictType")
    @ResponseBody
    public ResultData dictType  (@ModelAttribute @ApiIgnore DictEntity dict,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model) {
        dict.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List dictList = dictBiz.dictType(dict);
		return ResultData.build().success(new EUListBean(dictList,(int)BasicUtil.endPage(dictList).getTotal()));
    }
	
	/**
	 * 返回编辑界面dict_form
	 */
	@GetMapping("/form")
	public String form(@ModelAttribute DictEntity dict,HttpServletResponse response,HttpServletRequest request,@ApiIgnore ModelMap model){
		if(dict.getDictId() != null){
			BaseEntity dictEntity = dictBiz.getEntity(dict.getDictId());			
			model.addAttribute("dictEntity",dictEntity);
		}
		
		return "/mdiy/dict/form";
	}
	
	/**
	 * 获取字典表
	 * @param dict 字典表实体
	 * <i>dict参数包含字段信息参考：</i><br/>
	 * dictId 编号<br/>
	 * dictAppId 应用编号<br/>
	 * dictValue 数据值<br/>
	 * dictLabel 标签名<br/>
	 * dictType 类型<br/>
	 * dictDescription 描述<br/>
	 * dictSort 排序（升序）<br/>
	 * dictParentId 父级编号<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新者<br/>
	 * updateDate 更新时间<br/>
	 * dictRemarks 备注信息<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * dictId: 编号<br/>
	 * dictAppId: 应用编号<br/>
	 * dictValue: 数据值<br/>
	 * dictLabel: 标签名<br/>
	 * dictType: 类型<br/>
	 * dictDescription: 描述<br/>
	 * dictSort: 排序（升序）<br/>
	 * dictParentId: 父级编号<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新者<br/>
	 * updateDate: 更新时间<br/>
	 * dictRemarks: 备注信息<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "获取字典详情接口")
	@ApiImplicitParam(name = "dictId", value = "字典编号", required = true,paramType="query")
	@GetMapping("/get")
	@ResponseBody
	public ResultData get(@ModelAttribute @ApiIgnore DictEntity dict,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model){
		if(dict.getDictId()<=0) {
			return ResultData.build().error(getResString("err.error", this.getResString("dict.id")));
		}
		DictEntity _dict = (DictEntity)dictBiz.getEntity(dict.getDictId());
		return ResultData.build().success(_dict);
	}
	
	/**
	 * 保存字典表实体
	 * @param dict 字典表实体
	 * <i>dict参数包含字段信息参考：</i><br/>
	 * dictId 编号<br/>
	 * dictAppId 应用编号<br/>
	 * dictValue 数据值<br/>
	 * dictLabel 标签名<br/>
	 * dictType 类型<br/>
	 * dictDescription 描述<br/>
	 * dictSort 排序（升序）<br/>
	 * dictParentId 父级编号<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新者<br/>
	 * updateDate 更新时间<br/>
	 * dictRemarks 备注信息<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * dictId: 编号<br/>
	 * dictAppId: 应用编号<br/>
	 * dictValue: 数据值<br/>
	 * dictLabel: 标签名<br/>
	 * dictType: 类型<br/>
	 * dictDescription: 描述<br/>
	 * dictSort: 排序（升序）<br/>
	 * dictParentId: 父级编号<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新者<br/>
	 * updateDate: 更新时间<br/>
	 * dictRemarks: 备注信息<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "保存字典接口")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "dictLabel", value = "标签名", required = true,paramType="query"),
    	@ApiImplicitParam(name = "dictType", value = "类型", required = true,paramType="query"),
    	@ApiImplicitParam(name = "dictValue", value = "数据值", required =false,paramType="query"),
    	@ApiImplicitParam(name = "dictDescription", value = "描述", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictSort", value = "排序（升序）", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictParentId", value = "父级编号", required = false,paramType="query"),
    	@ApiImplicitParam(name = "isChild", value = "子业务关联", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictRemarks", value = "备注信息", required = false,paramType="query")
    })
	@LogAnn(title = "保存字典接口",businessType= BusinessTypeEnum.INSERT)
	@PostMapping("/save")
	@ResponseBody
	@RequiresPermissions("mdiy:dict:save")
	public ResultData save(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
		dict.setAppId(BasicUtil.getAppId());
		if(dictBiz.getByTypeAndLabel(dict.getDictType(),dict.getDictLabel())!=null){
			return ResultData.build().error(getResString("diy.dict.type.and.label.repeat"));
		}
		dictBiz.saveEntity(dict);
		if (StringUtil.isBlank(dict.getDictValue())){
			dict.setDictValue(dict.getDictId()+"");
			dictBiz.updateEntity(dict);
		}
		return ResultData.build().success();
	}
	
	/**
	 * @param dict 字典表实体
	 * <i>dict参数包含字段信息参考：</i><br/>
	 * dictId:多个dictId直接用逗号隔开,例如dictId=1,2,3,4
	 * 批量删除字典表
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            <dd>{code:"错误编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息"<br/>
	 *            }</dd>
	 */
	@ApiOperation(value = "批量删除字典")
	@LogAnn(title = "批量删除字典",businessType= BusinessTypeEnum.DELETE)
	@PostMapping("/delete")
	@ResponseBody
	@RequiresPermissions("mdiy:dict:del")
	public ResultData delete(@RequestBody List<DictEntity> dicts,HttpServletResponse response, HttpServletRequest request) {
		int[] ids = new int[dicts.size()];
		for(int i = 0;i<dicts.size();i++){
			ids[i] = dicts.get(i).getDictId();
		}
		dictBiz.delete(ids);
		return ResultData.build().success();
	}
	
	/** 
	 * 更新字典表信息字典表
	 * @param dict 字典表实体
	 * <i>dict参数包含字段信息参考：</i><br/>
	 * dictId 编号<br/>
	 * dictAppId 应用编号<br/>
	 * dictValue 数据值<br/>
	 * dictLabel 标签名<br/>
	 * dictType 类型<br/>
	 * dictDescription 描述<br/>
	 * dictSort 排序（升序）<br/>
	 * dictParentId 父级编号<br/>
	 * createBy 创建者<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新者<br/>
	 * updateDate 更新时间<br/>
	 * dictRemarks 备注信息<br/>
	 * del 删除标记<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * dictId: 编号<br/>
	 * dictAppId: 应用编号<br/>
	 * dictValue: 数据值<br/>
	 * dictLabel: 标签名<br/>
	 * dictType: 类型<br/>
	 * dictDescription: 描述<br/>
	 * dictSort: 排序（升序）<br/>
	 * dictParentId: 父级编号<br/>
	 * createBy: 创建者<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新者<br/>
	 * updateDate: 更新时间<br/>
	 * dictRemarks: 备注信息<br/>
	 * del: 删除标记<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "更新字典信息接口")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "dictId", value = "字典编号", required =true,paramType="query"),
		@ApiImplicitParam(name = "dictLabel", value = "标签名", required = true,paramType="query"),
    	@ApiImplicitParam(name = "dictType", value = "类型", required = true,paramType="query"),
    	@ApiImplicitParam(name = "dictValue", value = "数据值", required =false,paramType="query"),
    	@ApiImplicitParam(name = "dictDescription", value = "描述", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictSort", value = "排序（升序）", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictParentId", value = "父级编号", required = false,paramType="query"),
    	@ApiImplicitParam(name = "isChild", value = "子业务关联", required = false,paramType="query"),
    	@ApiImplicitParam(name = "dictRemarks", value = "备注信息", required = false,paramType="query")
    })
	@LogAnn(title = "更新字典信息接口",businessType= BusinessTypeEnum.UPDATE)
	@PostMapping("/update")
	@ResponseBody
	@RequiresPermissions("mdiy:dict:update")
	public ResultData update(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response,
			HttpServletRequest request) {
		DictEntity _dict = dictBiz.getByTypeAndLabel(dict.getDictType(),dict.getDictLabel());
		if(_dict!=null){
			if(!_dict.getDictId().equals(dict.getDictId())){
				return ResultData.build().error(getResString("diy.dict.type.and.label.repeat"));
			}
		}
		if (StringUtil.isBlank(dict.getDictValue())){
			dict.setDictValue(null);
		}
		dictBiz.updateEntity(dict);
		return ResultData.build().success();
	}
		
}