package net.mingsoft.mdiy.action.web;

import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.PageEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * @ClassName:  PageAction   
 * @Description:TODO(自定义页面)   
 * @author: 铭飞开发团队
 * @date:   2018年12月17日 下午6:10:12   
 *     
 * @Copyright: 2018 www.mingsoft.net Inc. All rights reserved.
 */
@Api("自定义页码接口")
@Controller("webDiyPath")
@RequestMapping(value={"/mdiyPage"})
public class PageAction extends BaseAction {

	/**
	 * 自定义页面业务层
	 */
	@Autowired
	private IPageBiz pageBiz;

	@ApiOperation(value = "自定义页面")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "diy", value = "请求地址", required = true,paramType="path")
	})
	@GetMapping(value = "/{diy}")
	public void diy(@PathVariable(value = "diy") String diy, HttpServletRequest req, HttpServletResponse resp) {
		Map<String,Object> map = BasicUtil.assemblyRequestMap();
		//设置动态解析
		map.put(ParserUtil.URL, BasicUtil.getUrl());
		map.put(ParserUtil.IS_DO,true);
		PageEntity page = new PageEntity();
		page.setPageKey(diy);
		PageEntity _page = (PageEntity) pageBiz.getEntity(page);
		try {
			String content = ParserUtil.generate(_page.getPagePath().replace(" ", ""), map, isMobileDevice(req));
			this.outString(resp, content);
		} catch (TemplateNotFoundException e1) {
			e1.printStackTrace();
		} catch (MalformedTemplateNameException e1) {
			e1.printStackTrace();
		} catch (ParseException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}
}
