package net.mingsoft.mdiy.biz;

import net.mingsoft.base.biz.IBaseBiz;

import java.util.List;
import java.util.Map;


/**
 * 自定义表单接口
 * @author 王天培QQ:78750478
 * @version 
 * 版本号：100-000-000<br/>
 * 创建日期：2012-03-15<br/>
 * 历史修订：<br/>
 */
public interface IPostBiz extends IBaseBiz{

	/**
	 * 保存自定义表单的数据
	 * @param formId 表单编号
	 * @param params　参数值集合
	 */
	void saveDiyFormData(int formId, Map<String, Object> params);


	/**
	 * 查询自定义表单的数据
	 * @param diyFormId　自定义表单ID
	 * @param map wheres查询条件map
	 * @return 返回map fileds:字段列表 list:记录集合
	 */
	List queryDiyFormData(int diyFormId, Map<String, Object> map);

	/**
	 * 删除记录
	 * @param id　记录编号
	 * @param diyFormId 表单编号
	 */
	void deleteQueryDiyFormData(int id, String diyFormId);
	
	/**
	 * 查询总数
	 * @param diyFormId 表单ID
	 * @return 返回查询总数
	 */
	int countDiyFormData(int diyFormId,Map<String,Object> params);

	
}
